<?php
/**
 * ObjectTypePropertyCreate
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Crm\Schemas
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Schemas
 *
 * The CRM uses schemas to define how custom objects should store and represent information in the HubSpot CRM. Schemas define details about an object's type, properties, and associations. The schema can be uniquely identified by its **object type ID**.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Crm\Schemas\Model;

use \ArrayAccess;
use \HubSpot\Client\Crm\Schemas\ObjectSerializer;

/**
 * ObjectTypePropertyCreate Class Doc Comment
 *
 * @category Class
 * @description Defines a property to create.
 * @package  HubSpot\Client\Crm\Schemas
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ObjectTypePropertyCreate implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ObjectTypePropertyCreate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'hidden' => 'bool',
        'option_sort_strategy' => 'string',
        'display_order' => 'int',
        'description' => 'string',
        'show_currency_symbol' => 'bool',
        'label' => 'string',
        'type' => 'string',
        'form_field' => 'bool',
        'group_name' => 'string',
        'referenced_object_type' => 'string',
        'text_display_hint' => 'string',
        'name' => 'string',
        'options' => '\HubSpot\Client\Crm\Schemas\Model\OptionInput[]',
        'searchable_in_global_search' => 'bool',
        'number_display_hint' => 'string',
        'has_unique_value' => 'bool',
        'field_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'hidden' => null,
        'option_sort_strategy' => null,
        'display_order' => 'int32',
        'description' => null,
        'show_currency_symbol' => null,
        'label' => null,
        'type' => null,
        'form_field' => null,
        'group_name' => null,
        'referenced_object_type' => null,
        'text_display_hint' => null,
        'name' => null,
        'options' => null,
        'searchable_in_global_search' => null,
        'number_display_hint' => null,
        'has_unique_value' => null,
        'field_type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'hidden' => false,
        'option_sort_strategy' => false,
        'display_order' => false,
        'description' => false,
        'show_currency_symbol' => false,
        'label' => false,
        'type' => false,
        'form_field' => false,
        'group_name' => false,
        'referenced_object_type' => false,
        'text_display_hint' => false,
        'name' => false,
        'options' => false,
        'searchable_in_global_search' => false,
        'number_display_hint' => false,
        'has_unique_value' => false,
        'field_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'hidden' => 'hidden',
        'option_sort_strategy' => 'optionSortStrategy',
        'display_order' => 'displayOrder',
        'description' => 'description',
        'show_currency_symbol' => 'showCurrencySymbol',
        'label' => 'label',
        'type' => 'type',
        'form_field' => 'formField',
        'group_name' => 'groupName',
        'referenced_object_type' => 'referencedObjectType',
        'text_display_hint' => 'textDisplayHint',
        'name' => 'name',
        'options' => 'options',
        'searchable_in_global_search' => 'searchableInGlobalSearch',
        'number_display_hint' => 'numberDisplayHint',
        'has_unique_value' => 'hasUniqueValue',
        'field_type' => 'fieldType'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'hidden' => 'setHidden',
        'option_sort_strategy' => 'setOptionSortStrategy',
        'display_order' => 'setDisplayOrder',
        'description' => 'setDescription',
        'show_currency_symbol' => 'setShowCurrencySymbol',
        'label' => 'setLabel',
        'type' => 'setType',
        'form_field' => 'setFormField',
        'group_name' => 'setGroupName',
        'referenced_object_type' => 'setReferencedObjectType',
        'text_display_hint' => 'setTextDisplayHint',
        'name' => 'setName',
        'options' => 'setOptions',
        'searchable_in_global_search' => 'setSearchableInGlobalSearch',
        'number_display_hint' => 'setNumberDisplayHint',
        'has_unique_value' => 'setHasUniqueValue',
        'field_type' => 'setFieldType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'hidden' => 'getHidden',
        'option_sort_strategy' => 'getOptionSortStrategy',
        'display_order' => 'getDisplayOrder',
        'description' => 'getDescription',
        'show_currency_symbol' => 'getShowCurrencySymbol',
        'label' => 'getLabel',
        'type' => 'getType',
        'form_field' => 'getFormField',
        'group_name' => 'getGroupName',
        'referenced_object_type' => 'getReferencedObjectType',
        'text_display_hint' => 'getTextDisplayHint',
        'name' => 'getName',
        'options' => 'getOptions',
        'searchable_in_global_search' => 'getSearchableInGlobalSearch',
        'number_display_hint' => 'getNumberDisplayHint',
        'has_unique_value' => 'getHasUniqueValue',
        'field_type' => 'getFieldType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const OPTION_SORT_STRATEGY_DISPLAY_ORDER = 'DISPLAY_ORDER';
    public const OPTION_SORT_STRATEGY_ALPHABETICAL = 'ALPHABETICAL';
    public const TYPE_STRING = 'string';
    public const TYPE_NUMBER = 'number';
    public const TYPE_DATE = 'date';
    public const TYPE_DATETIME = 'datetime';
    public const TYPE_ENUMERATION = 'enumeration';
    public const TYPE_BOOL = 'bool';
    public const TEXT_DISPLAY_HINT_UNFORMATTED_SINGLE_LINE = 'unformatted_single_line';
    public const TEXT_DISPLAY_HINT_MULTI_LINE = 'multi_line';
    public const TEXT_DISPLAY_HINT_EMAIL = 'email';
    public const TEXT_DISPLAY_HINT_PHONE_NUMBER = 'phone_number';
    public const TEXT_DISPLAY_HINT_DOMAIN_NAME = 'domain_name';
    public const TEXT_DISPLAY_HINT_IP_ADDRESS = 'ip_address';
    public const TEXT_DISPLAY_HINT_PHYSICAL_ADDRESS = 'physical_address';
    public const TEXT_DISPLAY_HINT_POSTAL_CODE = 'postal_code';
    public const NUMBER_DISPLAY_HINT_UNFORMATTED = 'unformatted';
    public const NUMBER_DISPLAY_HINT_FORMATTED = 'formatted';
    public const NUMBER_DISPLAY_HINT_CURRENCY = 'currency';
    public const NUMBER_DISPLAY_HINT_PERCENTAGE = 'percentage';
    public const NUMBER_DISPLAY_HINT_DURATION = 'duration';
    public const NUMBER_DISPLAY_HINT_PROBABILITY = 'probability';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getOptionSortStrategyAllowableValues()
    {
        return [
            self::OPTION_SORT_STRATEGY_DISPLAY_ORDER,
            self::OPTION_SORT_STRATEGY_ALPHABETICAL,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_STRING,
            self::TYPE_NUMBER,
            self::TYPE_DATE,
            self::TYPE_DATETIME,
            self::TYPE_ENUMERATION,
            self::TYPE_BOOL,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getTextDisplayHintAllowableValues()
    {
        return [
            self::TEXT_DISPLAY_HINT_UNFORMATTED_SINGLE_LINE,
            self::TEXT_DISPLAY_HINT_MULTI_LINE,
            self::TEXT_DISPLAY_HINT_EMAIL,
            self::TEXT_DISPLAY_HINT_PHONE_NUMBER,
            self::TEXT_DISPLAY_HINT_DOMAIN_NAME,
            self::TEXT_DISPLAY_HINT_IP_ADDRESS,
            self::TEXT_DISPLAY_HINT_PHYSICAL_ADDRESS,
            self::TEXT_DISPLAY_HINT_POSTAL_CODE,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getNumberDisplayHintAllowableValues()
    {
        return [
            self::NUMBER_DISPLAY_HINT_UNFORMATTED,
            self::NUMBER_DISPLAY_HINT_FORMATTED,
            self::NUMBER_DISPLAY_HINT_CURRENCY,
            self::NUMBER_DISPLAY_HINT_PERCENTAGE,
            self::NUMBER_DISPLAY_HINT_DURATION,
            self::NUMBER_DISPLAY_HINT_PROBABILITY,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('hidden', $data ?? [], null);
        $this->setIfExists('option_sort_strategy', $data ?? [], null);
        $this->setIfExists('display_order', $data ?? [], null);
        $this->setIfExists('description', $data ?? [], null);
        $this->setIfExists('show_currency_symbol', $data ?? [], null);
        $this->setIfExists('label', $data ?? [], null);
        $this->setIfExists('type', $data ?? [], null);
        $this->setIfExists('form_field', $data ?? [], null);
        $this->setIfExists('group_name', $data ?? [], null);
        $this->setIfExists('referenced_object_type', $data ?? [], null);
        $this->setIfExists('text_display_hint', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('options', $data ?? [], null);
        $this->setIfExists('searchable_in_global_search', $data ?? [], null);
        $this->setIfExists('number_display_hint', $data ?? [], null);
        $this->setIfExists('has_unique_value', $data ?? [], null);
        $this->setIfExists('field_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getOptionSortStrategyAllowableValues();
        if (!is_null($this->container['option_sort_strategy']) && !in_array($this->container['option_sort_strategy'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'option_sort_strategy', must be one of '%s'",
                $this->container['option_sort_strategy'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['label'] === null) {
            $invalidProperties[] = "'label' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!is_null($this->container['type']) && !in_array($this->container['type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'type', must be one of '%s'",
                $this->container['type'],
                implode("', '", $allowedValues)
            );
        }

        $allowedValues = $this->getTextDisplayHintAllowableValues();
        if (!is_null($this->container['text_display_hint']) && !in_array($this->container['text_display_hint'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'text_display_hint', must be one of '%s'",
                $this->container['text_display_hint'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        $allowedValues = $this->getNumberDisplayHintAllowableValues();
        if (!is_null($this->container['number_display_hint']) && !in_array($this->container['number_display_hint'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'number_display_hint', must be one of '%s'",
                $this->container['number_display_hint'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['field_type'] === null) {
            $invalidProperties[] = "'field_type' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets hidden
     *
     * @return bool|null
     */
    public function getHidden()
    {
        return $this->container['hidden'];
    }

    /**
     * Sets hidden
     *
     * @param bool|null $hidden hidden
     *
     * @return self
     */
    public function setHidden($hidden)
    {
        if (is_null($hidden)) {
            throw new \InvalidArgumentException('non-nullable hidden cannot be null');
        }
        $this->container['hidden'] = $hidden;

        return $this;
    }

    /**
     * Gets option_sort_strategy
     *
     * @return string|null
     */
    public function getOptionSortStrategy()
    {
        return $this->container['option_sort_strategy'];
    }

    /**
     * Sets option_sort_strategy
     *
     * @param string|null $option_sort_strategy Controls how the property options will be sorted in the HubSpot UI.
     *
     * @return self
     */
    public function setOptionSortStrategy($option_sort_strategy)
    {
        if (is_null($option_sort_strategy)) {
            throw new \InvalidArgumentException('non-nullable option_sort_strategy cannot be null');
        }
        $allowedValues = $this->getOptionSortStrategyAllowableValues();
        if (!in_array($option_sort_strategy, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'option_sort_strategy', must be one of '%s'",
                    $option_sort_strategy,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['option_sort_strategy'] = $option_sort_strategy;

        return $this;
    }

    /**
     * Gets display_order
     *
     * @return int|null
     */
    public function getDisplayOrder()
    {
        return $this->container['display_order'];
    }

    /**
     * Sets display_order
     *
     * @param int|null $display_order The order that this property should be displayed in the HubSpot UI relative to other properties for this object type. Properties are displayed in order starting with the lowest positive integer value. A value of -1 will cause the property to be displayed **after** any positive values.
     *
     * @return self
     */
    public function setDisplayOrder($display_order)
    {
        if (is_null($display_order)) {
            throw new \InvalidArgumentException('non-nullable display_order cannot be null');
        }
        $this->container['display_order'] = $display_order;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description A description of the property that will be shown as help text in HubSpot.
     *
     * @return self
     */
    public function setDescription($description)
    {
        if (is_null($description)) {
            throw new \InvalidArgumentException('non-nullable description cannot be null');
        }
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets show_currency_symbol
     *
     * @return bool|null
     */
    public function getShowCurrencySymbol()
    {
        return $this->container['show_currency_symbol'];
    }

    /**
     * Sets show_currency_symbol
     *
     * @param bool|null $show_currency_symbol Whether the property will display the currency symbol in the HubSpot UI.
     *
     * @return self
     */
    public function setShowCurrencySymbol($show_currency_symbol)
    {
        if (is_null($show_currency_symbol)) {
            throw new \InvalidArgumentException('non-nullable show_currency_symbol cannot be null');
        }
        $this->container['show_currency_symbol'] = $show_currency_symbol;

        return $this;
    }

    /**
     * Gets label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->container['label'];
    }

    /**
     * Sets label
     *
     * @param string $label A human-readable property label that will be shown in HubSpot.
     *
     * @return self
     */
    public function setLabel($label)
    {
        if (is_null($label)) {
            throw new \InvalidArgumentException('non-nullable label cannot be null');
        }
        $this->container['label'] = $label;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type The data type of the property.
     *
     * @return self
     */
    public function setType($type)
    {
        if (is_null($type)) {
            throw new \InvalidArgumentException('non-nullable type cannot be null');
        }
        $allowedValues = $this->getTypeAllowableValues();
        if (!in_array($type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'type', must be one of '%s'",
                    $type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets form_field
     *
     * @return bool|null
     */
    public function getFormField()
    {
        return $this->container['form_field'];
    }

    /**
     * Sets form_field
     *
     * @param bool|null $form_field Whether the property can be used in a HubSpot form.
     *
     * @return self
     */
    public function setFormField($form_field)
    {
        if (is_null($form_field)) {
            throw new \InvalidArgumentException('non-nullable form_field cannot be null');
        }
        $this->container['form_field'] = $form_field;

        return $this;
    }

    /**
     * Gets group_name
     *
     * @return string|null
     */
    public function getGroupName()
    {
        return $this->container['group_name'];
    }

    /**
     * Sets group_name
     *
     * @param string|null $group_name The name of the group this property belongs to.
     *
     * @return self
     */
    public function setGroupName($group_name)
    {
        if (is_null($group_name)) {
            throw new \InvalidArgumentException('non-nullable group_name cannot be null');
        }
        $this->container['group_name'] = $group_name;

        return $this;
    }

    /**
     * Gets referenced_object_type
     *
     * @return string|null
     */
    public function getReferencedObjectType()
    {
        return $this->container['referenced_object_type'];
    }

    /**
     * Sets referenced_object_type
     *
     * @param string|null $referenced_object_type Defines the options this property will return, e.g. OWNER would return name of users on the portal.
     *
     * @return self
     */
    public function setReferencedObjectType($referenced_object_type)
    {
        if (is_null($referenced_object_type)) {
            throw new \InvalidArgumentException('non-nullable referenced_object_type cannot be null');
        }
        $this->container['referenced_object_type'] = $referenced_object_type;

        return $this;
    }

    /**
     * Gets text_display_hint
     *
     * @return string|null
     */
    public function getTextDisplayHint()
    {
        return $this->container['text_display_hint'];
    }

    /**
     * Sets text_display_hint
     *
     * @param string|null $text_display_hint Controls how text properties are formatted in the HubSpot UI
     *
     * @return self
     */
    public function setTextDisplayHint($text_display_hint)
    {
        if (is_null($text_display_hint)) {
            throw new \InvalidArgumentException('non-nullable text_display_hint cannot be null');
        }
        $allowedValues = $this->getTextDisplayHintAllowableValues();
        if (!in_array($text_display_hint, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'text_display_hint', must be one of '%s'",
                    $text_display_hint,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['text_display_hint'] = $text_display_hint;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The internal property name, which must be used when referencing the property from the API.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets options
     *
     * @return \HubSpot\Client\Crm\Schemas\Model\OptionInput[]|null
     */
    public function getOptions()
    {
        return $this->container['options'];
    }

    /**
     * Sets options
     *
     * @param \HubSpot\Client\Crm\Schemas\Model\OptionInput[]|null $options A list of available options for the property. This field is only required for enumerated properties.
     *
     * @return self
     */
    public function setOptions($options)
    {
        if (is_null($options)) {
            throw new \InvalidArgumentException('non-nullable options cannot be null');
        }
        $this->container['options'] = $options;

        return $this;
    }

    /**
     * Gets searchable_in_global_search
     *
     * @return bool|null
     */
    public function getSearchableInGlobalSearch()
    {
        return $this->container['searchable_in_global_search'];
    }

    /**
     * Sets searchable_in_global_search
     *
     * @param bool|null $searchable_in_global_search Allow users to search for information entered to this field (limited to 3 properties)
     *
     * @return self
     */
    public function setSearchableInGlobalSearch($searchable_in_global_search)
    {
        if (is_null($searchable_in_global_search)) {
            throw new \InvalidArgumentException('non-nullable searchable_in_global_search cannot be null');
        }
        $this->container['searchable_in_global_search'] = $searchable_in_global_search;

        return $this;
    }

    /**
     * Gets number_display_hint
     *
     * @return string|null
     */
    public function getNumberDisplayHint()
    {
        return $this->container['number_display_hint'];
    }

    /**
     * Sets number_display_hint
     *
     * @param string|null $number_display_hint Controls how numeric properties are formatted in the HubSpot UI
     *
     * @return self
     */
    public function setNumberDisplayHint($number_display_hint)
    {
        if (is_null($number_display_hint)) {
            throw new \InvalidArgumentException('non-nullable number_display_hint cannot be null');
        }
        $allowedValues = $this->getNumberDisplayHintAllowableValues();
        if (!in_array($number_display_hint, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'number_display_hint', must be one of '%s'",
                    $number_display_hint,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['number_display_hint'] = $number_display_hint;

        return $this;
    }

    /**
     * Gets has_unique_value
     *
     * @return bool|null
     */
    public function getHasUniqueValue()
    {
        return $this->container['has_unique_value'];
    }

    /**
     * Sets has_unique_value
     *
     * @param bool|null $has_unique_value Whether or not the property's value must be unique. Once set, this can't be changed.
     *
     * @return self
     */
    public function setHasUniqueValue($has_unique_value)
    {
        if (is_null($has_unique_value)) {
            throw new \InvalidArgumentException('non-nullable has_unique_value cannot be null');
        }
        $this->container['has_unique_value'] = $has_unique_value;

        return $this;
    }

    /**
     * Gets field_type
     *
     * @return string
     */
    public function getFieldType()
    {
        return $this->container['field_type'];
    }

    /**
     * Sets field_type
     *
     * @param string $field_type Controls how the property appears in HubSpot.
     *
     * @return self
     */
    public function setFieldType($field_type)
    {
        if (is_null($field_type)) {
            throw new \InvalidArgumentException('non-nullable field_type cannot be null');
        }
        $this->container['field_type'] = $field_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


