<?php
/**
 * PublicPerformanceResponse
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Performance
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * CMS Performance
 *
 * Use these endpoints to get a time series view of your website's performance.
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Cms\Performance\Model;

use \ArrayAccess;
use \HubSpot\Client\Cms\Performance\ObjectSerializer;

/**
 * PublicPerformanceResponse Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Cms\Performance
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PublicPerformanceResponse implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PublicPerformanceResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'path' => 'string',
        'period' => 'string',
        'start_interval' => 'int',
        'data' => '\HubSpot\Client\Cms\Performance\Model\PerformanceView[]',
        'domain' => 'string',
        'interval' => 'string',
        'end_interval' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'path' => null,
        'period' => null,
        'start_interval' => 'int64',
        'data' => null,
        'domain' => null,
        'interval' => null,
        'end_interval' => 'int64'
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'path' => false,
        'period' => false,
        'start_interval' => false,
        'data' => false,
        'domain' => false,
        'interval' => false,
        'end_interval' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'path' => 'path',
        'period' => 'period',
        'start_interval' => 'startInterval',
        'data' => 'data',
        'domain' => 'domain',
        'interval' => 'interval',
        'end_interval' => 'endInterval'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'path' => 'setPath',
        'period' => 'setPeriod',
        'start_interval' => 'setStartInterval',
        'data' => 'setData',
        'domain' => 'setDomain',
        'interval' => 'setInterval',
        'end_interval' => 'setEndInterval'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'path' => 'getPath',
        'period' => 'getPeriod',
        'start_interval' => 'getStartInterval',
        'data' => 'getData',
        'domain' => 'getDomain',
        'interval' => 'getInterval',
        'end_interval' => 'getEndInterval'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const PERIOD_ONE_MINUTE = 'ONE_MINUTE';
    public const PERIOD_FIVE_MINUTES = 'FIVE_MINUTES';
    public const PERIOD_TEN_MINUTES = 'TEN_MINUTES';
    public const PERIOD_FIFTEEN_MINUTES = 'FIFTEEN_MINUTES';
    public const PERIOD_THIRTY_MINUTES = 'THIRTY_MINUTES';
    public const PERIOD_ONE_HOUR = 'ONE_HOUR';
    public const PERIOD_FOUR_HOURS = 'FOUR_HOURS';
    public const PERIOD_TWELVE_HOURS = 'TWELVE_HOURS';
    public const PERIOD_ONE_DAY = 'ONE_DAY';
    public const PERIOD_ONE_WEEK = 'ONE_WEEK';
    public const INTERVAL_ONE_MINUTE = 'ONE_MINUTE';
    public const INTERVAL_FIVE_MINUTES = 'FIVE_MINUTES';
    public const INTERVAL_TEN_MINUTES = 'TEN_MINUTES';
    public const INTERVAL_FIFTEEN_MINUTES = 'FIFTEEN_MINUTES';
    public const INTERVAL_THIRTY_MINUTES = 'THIRTY_MINUTES';
    public const INTERVAL_ONE_HOUR = 'ONE_HOUR';
    public const INTERVAL_FOUR_HOURS = 'FOUR_HOURS';
    public const INTERVAL_TWELVE_HOURS = 'TWELVE_HOURS';
    public const INTERVAL_ONE_DAY = 'ONE_DAY';
    public const INTERVAL_ONE_WEEK = 'ONE_WEEK';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getPeriodAllowableValues()
    {
        return [
            self::PERIOD_ONE_MINUTE,
            self::PERIOD_FIVE_MINUTES,
            self::PERIOD_TEN_MINUTES,
            self::PERIOD_FIFTEEN_MINUTES,
            self::PERIOD_THIRTY_MINUTES,
            self::PERIOD_ONE_HOUR,
            self::PERIOD_FOUR_HOURS,
            self::PERIOD_TWELVE_HOURS,
            self::PERIOD_ONE_DAY,
            self::PERIOD_ONE_WEEK,
        ];
    }

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getIntervalAllowableValues()
    {
        return [
            self::INTERVAL_ONE_MINUTE,
            self::INTERVAL_FIVE_MINUTES,
            self::INTERVAL_TEN_MINUTES,
            self::INTERVAL_FIFTEEN_MINUTES,
            self::INTERVAL_THIRTY_MINUTES,
            self::INTERVAL_ONE_HOUR,
            self::INTERVAL_FOUR_HOURS,
            self::INTERVAL_TWELVE_HOURS,
            self::INTERVAL_ONE_DAY,
            self::INTERVAL_ONE_WEEK,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('path', $data ?? [], null);
        $this->setIfExists('period', $data ?? [], null);
        $this->setIfExists('start_interval', $data ?? [], null);
        $this->setIfExists('data', $data ?? [], null);
        $this->setIfExists('domain', $data ?? [], null);
        $this->setIfExists('interval', $data ?? [], null);
        $this->setIfExists('end_interval', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        $allowedValues = $this->getPeriodAllowableValues();
        if (!is_null($this->container['period']) && !in_array($this->container['period'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'period', must be one of '%s'",
                $this->container['period'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['start_interval'] === null) {
            $invalidProperties[] = "'start_interval' can't be null";
        }
        if ($this->container['data'] === null) {
            $invalidProperties[] = "'data' can't be null";
        }
        if ($this->container['interval'] === null) {
            $invalidProperties[] = "'interval' can't be null";
        }
        $allowedValues = $this->getIntervalAllowableValues();
        if (!is_null($this->container['interval']) && !in_array($this->container['interval'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'interval', must be one of '%s'",
                $this->container['interval'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['end_interval'] === null) {
            $invalidProperties[] = "'end_interval' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets path
     *
     * @return string|null
     */
    public function getPath()
    {
        return $this->container['path'];
    }

    /**
     * Sets path
     *
     * @param string|null $path path
     *
     * @return self
     */
    public function setPath($path)
    {
        if (is_null($path)) {
            throw new \InvalidArgumentException('non-nullable path cannot be null');
        }
        $this->container['path'] = $path;

        return $this;
    }

    /**
     * Gets period
     *
     * @return string|null
     */
    public function getPeriod()
    {
        return $this->container['period'];
    }

    /**
     * Sets period
     *
     * @param string|null $period period
     *
     * @return self
     */
    public function setPeriod($period)
    {
        if (is_null($period)) {
            throw new \InvalidArgumentException('non-nullable period cannot be null');
        }
        $allowedValues = $this->getPeriodAllowableValues();
        if (!in_array($period, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'period', must be one of '%s'",
                    $period,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['period'] = $period;

        return $this;
    }

    /**
     * Gets start_interval
     *
     * @return int
     */
    public function getStartInterval()
    {
        return $this->container['start_interval'];
    }

    /**
     * Sets start_interval
     *
     * @param int $start_interval start_interval
     *
     * @return self
     */
    public function setStartInterval($start_interval)
    {
        if (is_null($start_interval)) {
            throw new \InvalidArgumentException('non-nullable start_interval cannot be null');
        }
        $this->container['start_interval'] = $start_interval;

        return $this;
    }

    /**
     * Gets data
     *
     * @return \HubSpot\Client\Cms\Performance\Model\PerformanceView[]
     */
    public function getData()
    {
        return $this->container['data'];
    }

    /**
     * Sets data
     *
     * @param \HubSpot\Client\Cms\Performance\Model\PerformanceView[] $data data
     *
     * @return self
     */
    public function setData($data)
    {
        if (is_null($data)) {
            throw new \InvalidArgumentException('non-nullable data cannot be null');
        }
        $this->container['data'] = $data;

        return $this;
    }

    /**
     * Gets domain
     *
     * @return string|null
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     *
     * @param string|null $domain domain
     *
     * @return self
     */
    public function setDomain($domain)
    {
        if (is_null($domain)) {
            throw new \InvalidArgumentException('non-nullable domain cannot be null');
        }
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets interval
     *
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     *
     * @param string $interval interval
     *
     * @return self
     */
    public function setInterval($interval)
    {
        if (is_null($interval)) {
            throw new \InvalidArgumentException('non-nullable interval cannot be null');
        }
        $allowedValues = $this->getIntervalAllowableValues();
        if (!in_array($interval, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'interval', must be one of '%s'",
                    $interval,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets end_interval
     *
     * @return int
     */
    public function getEndInterval()
    {
        return $this->container['end_interval'];
    }

    /**
     * Sets end_interval
     *
     * @param int $end_interval end_interval
     *
     * @return self
     */
    public function setEndInterval($end_interval)
    {
        if (is_null($end_interval)) {
            throw new \InvalidArgumentException('non-nullable end_interval cannot be null');
        }
        $this->container['end_interval'] = $end_interval;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


