@php
    $elements = [
        'primitive' => [
            [
                'type' => 'Rect',
                'icon' => 'tabler-square',
                'label' => __('Rectangle'),
                'attrs' => [
                    'width' => 100,
                    'height' => 100,
                ],
            ],
            [
                'type' => 'Ellipse',
                'icon' => 'tabler-circle',
                'label' => __('Ellipse'),
                'attrs' => [
                    'width' => 100,
                    'height' => 100,
                ],
            ],
            // [
            //     'type' => 'Text',
            //     'icon' => 'tabler-letter-t',
            //     'label' => __('Text'),
            // ],
            // [
            //     'type' => 'Image',
            //     'icon' => 'tabler-photo',
            //     'label' => __('Image'),
            //     'attrs' => [
            //         'width' => 200,
            //         'height' => 200,
            //     ],
            // ],
            [
                'type' => 'TextPath',
                'icon' => 'tabler-route-2',
                'label' => __('Text Path'),
                'attrs' => [
                    'width' => 200,
                    'height' => 200,
                    'data' =>
                        'M200.195 100.483C200.195 155.711 155.424 200.483 100.195 200.483C44.967 200.483 0.195442 155.711 0.195442 100.483C0.195442 45.2542 44.967 0.482632 100.195 0.482632C155.424 0.482632 200.195 45.2542 200.195 100.483Z',
                ],
            ],
            [
                'type' => 'RegularPolygon',
                'icon' => 'tabler-polygon',
                'label' => __('Polygon'),
                'attrs' => [
                    'radius' => 50,
                    'sides' => 5,
                ],
            ],
            // [
            //     'type' => 'Line',
            //     'icon' => 'tabler-line',
            //     'label' => __('Line'),
            //     'attrs' => [
            //         'points' => [0, 0, 150, -150],
            //     ],
            // ],
            // [
            //     'type' => 'Arrow',
            //     'icon' => 'tabler-arrow-right',
            //     'label' => __('Arrow'),
            //     'attrs' => [
            //         'points' => [0, 0, 150, -150],
            //     ],
            // ],
            [
                'type' => 'Star',
                'icon' => 'tabler-star',
                'label' => __('Star'),
                'attrs' => [
                    'numPoints' => 5,
                    'innerRadius' => 30,
                    'outerRadius' => 70,
                ],
            ],
            [
                'type' => 'Arc',
                'svg' =>
                    '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="currentColor" stroke-width="1.75" stroke-linejoin="round"> <path d="M21.6249 12C21.6249 13.9036 21.0605 15.7645 20.0029 17.3473C18.9452 18.9301 17.442 20.1638 15.6833 20.8923C13.9246 21.6208 11.9893 21.8114 10.1223 21.44C8.25521 21.0686 6.54021 20.1519 5.19413 18.8059C3.84806 17.4598 2.93137 15.7448 2.55999 13.8777C2.18861 12.0107 2.37922 10.0754 3.10771 8.31669C3.8362 6.55796 5.06985 5.05475 6.65267 3.99715C8.23548 2.93955 10.0964 2.37505 12 2.37505V8.15002C11.2385 8.15002 10.4942 8.37582 9.86107 8.79886C9.22794 9.2219 8.73448 9.82319 8.44308 10.5267C8.15169 11.2302 8.07545 12.0043 8.224 12.7511C8.37255 13.4979 8.73922 14.1839 9.27765 14.7223C9.81608 15.2608 10.5021 15.6275 11.2489 15.776C11.9957 15.9246 12.7698 15.8483 13.4733 15.5569C14.1768 15.2655 14.7781 14.7721 15.2011 14.1389C15.6242 13.5058 15.85 12.7615 15.85 12H21.6249Z"/> </svg>',
                'label' => __('Arc'),
                'attrs' => [
                    'angle' => 85,
                    'innerRadius' => 30,
                    'outerRadius' => 70,
                ],
            ],
            [
                'type' => 'Ring',
                'svg' =>
                    '<svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="currentColor" stroke-width="1.75"><path d="M12.0001 1.19544C17.9673 1.19552 22.8048 6.03298 22.8048 12.0001C22.8047 17.9672 17.9672 22.8047 12.0001 22.8048C6.03298 22.8048 1.19551 17.9673 1.19544 12.0001C1.19544 6.03294 6.03294 1.19544 12.0001 1.19544ZM12.0001 5.83802C8.59713 5.83802 5.83802 8.59713 5.83802 12.0001C5.83809 15.4031 8.59717 18.1613 12.0001 18.1613C15.403 18.1612 18.1612 15.403 18.1613 12.0001C18.1613 8.59717 15.4031 5.83809 12.0001 5.83802Z"/></svg>',
                'label' => __('Ring'),
                'attrs' => [
                    'innerRadius' => 30,
                    'outerRadius' => 70,
                ],
            ],
            [
                'type' => 'Wedge',
                'svg' =>
                    '<svg width="24" height="24" viewBox="0 0 26 26" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="currentColor" stroke-width="2" stroke-linejoin="round"><path d="M12 1.38568C9.90068 1.38568 7.84851 2.0082 6.103 3.17451C4.35748 4.34083 2.99702 5.99856 2.19364 7.93807C1.39027 9.87759 1.18007 12.0118 1.58963 14.0708C1.99918 16.1297 3.0101 18.021 4.49454 19.5055C5.97898 20.9899 7.87027 22.0008 9.92925 22.4104C11.9882 22.8199 14.1224 22.6097 16.0619 21.8064C18.0014 21.003 19.6592 19.6425 20.8255 17.897C21.9918 16.1515 22.6143 14.0993 22.6143 12H12V1.38568Z"/></svg>',
                'label' => __('Wedge'),
                'attrs' => [
                    'radius' => 70,
                    'angle' => 60,
                ],
            ],
        ],
        'custom' => [
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="200" viewBox="0 0 200 200" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M94.7917 200C92.8819 188.715 87.8472 176.562 79.6875 163.542C71.5278 150.347 59.8958 138.108 44.7917 126.823C29.8611 115.538 14.9306 108.333 0 105.208V94.2708C14.7569 90.7986 28.9062 84.375 42.4479 75C56.1632 65.4514 67.6215 53.993 76.8229 40.625C86.1979 26.9097 92.1875 13.368 94.7917 0H105.729C107.292 8.68055 110.417 17.6215 115.104 26.8229C119.792 35.8507 125.781 44.5312 133.073 52.8646C140.538 61.0243 148.872 68.4028 158.073 75C171.788 84.7222 185.764 91.1458 200 94.2708V105.208C190.451 107.118 180.556 111.024 170.312 116.927C160.243 122.83 150.868 129.861 142.187 138.021C133.507 146.007 126.389 154.427 120.833 163.281C112.674 176.302 107.639 188.542 105.729 200H94.7917Z"/></svg>',
                'attrs' => [
                    'data' =>
                        'M94.7917 200C92.8819 188.715 87.8472 176.562 79.6875 163.542C71.5278 150.347 59.8958 138.108 44.7917 126.823C29.8611 115.538 14.9306 108.333 0 105.208V94.2708C14.7569 90.7986 28.9062 84.375 42.4479 75C56.1632 65.4514 67.6215 53.993 76.8229 40.625C86.1979 26.9097 92.1875 13.368 94.7917 0H105.729C107.292 8.68055 110.417 17.6215 115.104 26.8229C119.792 35.8507 125.781 44.5312 133.073 52.8646C140.538 61.0243 148.872 68.4028 158.073 75C171.788 84.7222 185.764 91.1458 200 94.2708V105.208C190.451 107.118 180.556 111.024 170.312 116.927C160.243 122.83 150.868 129.861 142.187 138.021C133.507 146.007 126.389 154.427 120.833 163.281C112.674 176.302 107.639 188.542 105.729 200H94.7917Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="200" viewBox="0 0 200 200" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M59.6059 177L30.5419 169.625L52.7094 104.725L0 69.8167H64.532L87.6847 0L114.286 7.86667L134.975 69.8167H182.759L200 74.7333L149.261 111.608L169.458 170.608L141.872 169.625L104.926 142.092L59.6059 177ZM43.8424 155.858L90.1478 121.442L136.453 155.858L117.734 103.25L160.591 75.7167H108.867L90.1478 13.7667L70.936 75.7167H19.7044L62.5616 103.25L43.8424 155.858Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M59.6059 177L30.5419 169.625L52.7094 104.725L0 69.8167H64.532L87.6847 0L114.286 7.86667L134.975 69.8167H182.759L200 74.7333L149.261 111.608L169.458 170.608L141.872 169.625L104.926 142.092L59.6059 177ZM43.8424 155.858L90.1478 121.442L136.453 155.858L117.734 103.25L160.591 75.7167H108.867L90.1478 13.7667L70.936 75.7167H19.7044L62.5616 103.25L43.8424 155.858Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="206" viewBox="0 0 200 206" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M100.258 200C94.9182 200 90.3531 198.105 86.5633 194.315C82.9457 190.698 81.137 186.219 81.137 180.879C81.137 179.5 81.137 178.295 81.137 177.261C81.3092 176.227 81.4815 175.366 81.6537 174.677C76.8303 173.988 72.8682 171.921 69.7674 168.475C66.6667 165.03 65.1163 160.896 65.1163 156.072C65.1163 150.904 66.9251 146.426 70.5426 142.636C74.1602 138.846 78.7252 136.951 84.2377 136.951C88.8889 136.951 92.851 138.329 96.124 141.085L95.0904 104.91L59.4315 103.876C62.1878 107.149 63.5659 111.111 63.5659 115.762C63.5659 121.103 61.7571 125.668 58.1395 129.457C54.522 133.075 49.9569 134.884 44.4444 134.884C39.7933 134.884 35.5728 133.419 31.7829 130.491C28.1654 127.39 26.0121 123.342 25.323 118.346C23.4281 119.035 21.3609 119.38 19.1214 119.38C13.7812 119.38 9.21619 117.571 5.42636 113.953C1.80879 110.164 0 105.599 0 100.258C0 94.7459 1.80879 90.1809 5.42636 86.5633C9.21619 82.9457 13.7812 81.137 19.1214 81.137C19.9828 81.137 20.9302 81.2231 21.9638 81.3954C22.9974 81.5676 24.1171 81.826 25.323 82.1705C26.1843 77.1749 28.4238 73.1266 32.0413 70.0258C35.8312 66.7528 39.9655 65.1163 44.4444 65.1163C49.7847 65.1163 54.2636 67.0112 57.8811 70.801C61.671 74.4186 63.5659 78.8975 63.5659 84.2377C63.5659 88.8889 62.1878 92.851 59.4315 96.124L95.0904 95.0904L96.124 59.4315C92.3342 62.1878 88.3721 63.5659 84.2377 63.5659C78.8975 63.5659 74.3325 61.7571 70.5426 58.1395C66.9251 54.3497 65.1163 49.7847 65.1163 44.4444C65.1163 39.7933 66.5805 35.6589 69.509 32.0413C72.6098 28.2515 76.6581 26.0121 81.6537 25.323C81.4815 24.6339 81.3092 23.7726 81.137 22.739C81.137 21.7054 81.137 20.4996 81.137 19.1214C81.137 13.7812 82.9457 9.30232 86.5633 5.68476C90.1809 1.89492 94.7459 0 100.258 0C105.599 0 110.078 1.89492 113.695 5.68476C117.485 9.30232 119.38 13.7812 119.38 19.1214C119.38 21.3609 119.035 23.4281 118.346 25.323C123.342 26.0121 127.304 28.2515 130.233 32.0413C133.333 35.6589 134.884 39.7933 134.884 44.4444C134.884 49.7847 132.989 54.3497 129.199 58.1395C125.581 61.7571 121.103 63.5659 115.762 63.5659C111.628 63.5659 107.666 62.1878 103.876 59.4315L104.91 95.0904L141.085 96.6408C137.985 92.6787 136.434 88.5444 136.434 84.2377C136.434 78.8975 138.243 74.4186 141.86 70.801C145.65 67.0112 150.215 65.1163 155.556 65.1163C160.034 65.1163 164.169 66.7528 167.959 70.0258C171.749 73.1266 173.988 77.1749 174.677 82.1705C175.883 81.826 177.003 81.5676 178.036 81.3954C179.242 81.2231 180.19 81.137 180.879 81.137C186.219 81.137 190.698 82.9457 194.315 86.5633C198.105 90.1809 200 94.7459 200 100.258C200 105.599 198.105 110.164 194.315 113.953C190.698 117.571 186.219 119.38 180.879 119.38C178.639 119.38 176.572 119.035 174.677 118.346C173.988 123.17 171.835 127.132 168.217 130.233C164.6 133.333 160.379 134.884 155.556 134.884C150.215 134.884 145.65 133.075 141.86 129.457C138.243 125.668 136.434 121.103 136.434 115.762C136.434 111.628 137.985 107.666 141.085 103.876L104.91 104.91L103.876 141.085C107.149 138.329 111.111 136.951 115.762 136.951C121.103 136.951 125.581 138.846 129.199 142.636C132.989 146.253 134.884 150.732 134.884 156.072C134.884 160.896 133.333 165.03 130.233 168.475C127.132 171.921 123.17 173.988 118.346 174.677C119.035 176.572 119.38 178.639 119.38 180.879C119.38 186.219 117.485 190.698 113.695 194.315C110.078 198.105 105.599 200 100.258 200Z" /></svg>',
                'attrs' => [
                    'data' =>
                        'M100.258 200C94.9182 200 90.3531 198.105 86.5633 194.315C82.9457 190.698 81.137 186.219 81.137 180.879C81.137 179.5 81.137 178.295 81.137 177.261C81.3092 176.227 81.4815 175.366 81.6537 174.677C76.8303 173.988 72.8682 171.921 69.7674 168.475C66.6667 165.03 65.1163 160.896 65.1163 156.072C65.1163 150.904 66.9251 146.426 70.5426 142.636C74.1602 138.846 78.7252 136.951 84.2377 136.951C88.8889 136.951 92.851 138.329 96.124 141.085L95.0904 104.91L59.4315 103.876C62.1878 107.149 63.5659 111.111 63.5659 115.762C63.5659 121.103 61.7571 125.668 58.1395 129.457C54.522 133.075 49.9569 134.884 44.4444 134.884C39.7933 134.884 35.5728 133.419 31.7829 130.491C28.1654 127.39 26.0121 123.342 25.323 118.346C23.4281 119.035 21.3609 119.38 19.1214 119.38C13.7812 119.38 9.21619 117.571 5.42636 113.953C1.80879 110.164 0 105.599 0 100.258C0 94.7459 1.80879 90.1809 5.42636 86.5633C9.21619 82.9457 13.7812 81.137 19.1214 81.137C19.9828 81.137 20.9302 81.2231 21.9638 81.3954C22.9974 81.5676 24.1171 81.826 25.323 82.1705C26.1843 77.1749 28.4238 73.1266 32.0413 70.0258C35.8312 66.7528 39.9655 65.1163 44.4444 65.1163C49.7847 65.1163 54.2636 67.0112 57.8811 70.801C61.671 74.4186 63.5659 78.8975 63.5659 84.2377C63.5659 88.8889 62.1878 92.851 59.4315 96.124L95.0904 95.0904L96.124 59.4315C92.3342 62.1878 88.3721 63.5659 84.2377 63.5659C78.8975 63.5659 74.3325 61.7571 70.5426 58.1395C66.9251 54.3497 65.1163 49.7847 65.1163 44.4444C65.1163 39.7933 66.5805 35.6589 69.509 32.0413C72.6098 28.2515 76.6581 26.0121 81.6537 25.323C81.4815 24.6339 81.3092 23.7726 81.137 22.739C81.137 21.7054 81.137 20.4996 81.137 19.1214C81.137 13.7812 82.9457 9.30232 86.5633 5.68476C90.1809 1.89492 94.7459 0 100.258 0C105.599 0 110.078 1.89492 113.695 5.68476C117.485 9.30232 119.38 13.7812 119.38 19.1214C119.38 21.3609 119.035 23.4281 118.346 25.323C123.342 26.0121 127.304 28.2515 130.233 32.0413C133.333 35.6589 134.884 39.7933 134.884 44.4444C134.884 49.7847 132.989 54.3497 129.199 58.1395C125.581 61.7571 121.103 63.5659 115.762 63.5659C111.628 63.5659 107.666 62.1878 103.876 59.4315L104.91 95.0904L141.085 96.6408C137.985 92.6787 136.434 88.5444 136.434 84.2377C136.434 78.8975 138.243 74.4186 141.86 70.801C145.65 67.0112 150.215 65.1163 155.556 65.1163C160.034 65.1163 164.169 66.7528 167.959 70.0258C171.749 73.1266 173.988 77.1749 174.677 82.1705C175.883 81.826 177.003 81.5676 178.036 81.3954C179.242 81.2231 180.19 81.137 180.879 81.137C186.219 81.137 190.698 82.9457 194.315 86.5633C198.105 90.1809 200 94.7459 200 100.258C200 105.599 198.105 110.164 194.315 113.953C190.698 117.571 186.219 119.38 180.879 119.38C178.639 119.38 176.572 119.035 174.677 118.346C173.988 123.17 171.835 127.132 168.217 130.233C164.6 133.333 160.379 134.884 155.556 134.884C150.215 134.884 145.65 133.075 141.86 129.457C138.243 125.668 136.434 121.103 136.434 115.762C136.434 111.628 137.985 107.666 141.085 103.876L104.91 104.91L103.876 141.085C107.149 138.329 111.111 136.951 115.762 136.951C121.103 136.951 125.581 138.846 129.199 142.636C132.989 146.253 134.884 150.732 134.884 156.072C134.884 160.896 133.333 165.03 130.233 168.475C127.132 171.921 123.17 173.988 118.346 174.677C119.035 176.572 119.38 178.639 119.38 180.879C119.38 186.219 117.485 190.698 113.695 194.315C110.078 198.105 105.599 200 100.258 200Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="206" viewBox="0 0 200 206" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M78.5714 206V140.509L21.4286 173.254L0 135.746L56.5476 103L0 70.2543L21.4286 32.7457L78.5714 65.4913V0H122.024V65.4913L178.571 32.7457L200 70.2543L143.452 103L200 135.746L178.571 173.254L122.024 140.509V206H78.5714Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M78.5714 206V140.509L21.4286 173.254L0 135.746L56.5476 103L0 70.2543L21.4286 32.7457L78.5714 65.4913V0H122.024V65.4913L178.571 32.7457L200 70.2543L143.452 103L200 135.746L178.571 173.254L122.024 140.509V206H78.5714Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="200" viewBox="0 0 200 200" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M94.2708 200C92.5347 188.715 87.5 176.562 79.1667 163.542C71.0069 150.521 59.375 138.281 44.2708 126.823C28.9931 115.191 14.2361 107.986 0 105.208V94.2708C14.4097 90.9722 28.3854 84.5486 41.9271 75C55.4688 65.4514 66.9271 54.0799 76.3021 40.8854C85.6771 27.5174 91.6667 13.8889 94.2708 0H105.208C106.771 8.85417 109.896 17.7951 114.583 26.8229C119.444 35.8507 125.608 44.5312 133.073 52.8646C140.538 61.0243 148.785 68.4028 157.812 75C171.528 84.7222 185.59 91.1458 200 94.2708V105.208C190.278 107.118 180.295 111.024 170.052 116.927C159.983 122.83 150.608 129.774 141.927 137.76C133.247 145.747 126.128 154.167 120.573 163.021C112.066 176.562 106.944 188.889 105.208 200H94.2708ZM97.9167 193.75H101.562C102.431 184.722 103.819 175.694 105.729 166.667C107.812 157.465 110.156 148.958 112.76 141.146C115.538 133.333 118.403 126.91 121.354 121.875C127.257 118.576 134.288 115.538 142.448 112.76C150.781 109.983 159.375 107.639 168.229 105.729C177.257 103.819 185.59 102.604 193.229 102.083V98.4375C185.59 97.743 177.17 96.441 167.969 94.5312C158.941 92.4479 150.26 90.0173 141.927 87.2396C133.594 84.2882 126.736 81.25 121.354 78.125C118.403 72.9167 115.538 66.493 112.76 58.8542C110.156 51.0417 107.812 42.7083 105.729 33.8542C103.819 24.8264 102.431 15.7986 101.562 6.77082H97.9167C97.2222 14.9305 95.9201 23.4375 94.0104 32.2917C92.2743 40.9722 90.0174 49.3055 87.2396 57.2917C84.4618 65.2778 81.4236 72.2222 78.125 78.125C72.5694 81.25 65.7118 84.2882 57.5521 87.2396C49.3924 90.0173 40.7986 92.4479 31.7708 94.5312C22.7431 96.441 14.2361 97.743 6.25 98.4375V102.083C14.2361 102.604 22.6562 103.819 31.5104 105.729C40.3646 107.639 48.8715 109.983 57.0312 112.76C65.191 115.538 72.2222 118.576 78.125 121.875C81.4236 127.431 84.375 134.288 86.9792 142.448C89.7569 150.434 92.1007 158.941 94.0104 167.969C95.9201 176.823 97.2222 185.417 97.9167 193.75Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M94.2708 200C92.5347 188.715 87.5 176.562 79.1667 163.542C71.0069 150.521 59.375 138.281 44.2708 126.823C28.9931 115.191 14.2361 107.986 0 105.208V94.2708C14.4097 90.9722 28.3854 84.5486 41.9271 75C55.4688 65.4514 66.9271 54.0799 76.3021 40.8854C85.6771 27.5174 91.6667 13.8889 94.2708 0H105.208C106.771 8.85417 109.896 17.7951 114.583 26.8229C119.444 35.8507 125.608 44.5312 133.073 52.8646C140.538 61.0243 148.785 68.4028 157.812 75C171.528 84.7222 185.59 91.1458 200 94.2708V105.208C190.278 107.118 180.295 111.024 170.052 116.927C159.983 122.83 150.608 129.774 141.927 137.76C133.247 145.747 126.128 154.167 120.573 163.021C112.066 176.562 106.944 188.889 105.208 200H94.2708ZM97.9167 193.75H101.562C102.431 184.722 103.819 175.694 105.729 166.667C107.812 157.465 110.156 148.958 112.76 141.146C115.538 133.333 118.403 126.91 121.354 121.875C127.257 118.576 134.288 115.538 142.448 112.76C150.781 109.983 159.375 107.639 168.229 105.729C177.257 103.819 185.59 102.604 193.229 102.083V98.4375C185.59 97.743 177.17 96.441 167.969 94.5312C158.941 92.4479 150.26 90.0173 141.927 87.2396C133.594 84.2882 126.736 81.25 121.354 78.125C118.403 72.9167 115.538 66.493 112.76 58.8542C110.156 51.0417 107.812 42.7083 105.729 33.8542C103.819 24.8264 102.431 15.7986 101.562 6.77082H97.9167C97.2222 14.9305 95.9201 23.4375 94.0104 32.2917C92.2743 40.9722 90.0174 49.3055 87.2396 57.2917C84.4618 65.2778 81.4236 72.2222 78.125 78.125C72.5694 81.25 65.7118 84.2882 57.5521 87.2396C49.3924 90.0173 40.7986 92.4479 31.7708 94.5312C22.7431 96.441 14.2361 97.743 6.25 98.4375V102.083C14.2361 102.604 22.6562 103.819 31.5104 105.729C40.3646 107.639 48.8715 109.983 57.0312 112.76C65.191 115.538 72.2222 118.576 78.125 121.875C81.4236 127.431 84.375 134.288 86.9792 142.448C89.7569 150.434 92.1007 158.941 94.0104 167.969C95.9201 176.823 97.2222 185.417 97.9167 193.75Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="222" viewBox="0 0 200 222" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M100.151 222C92.4861 222 85.9304 219.379 80.4841 214.136C75.0378 208.894 72.3147 202.341 72.3147 194.477C72.3147 187.823 74.3318 182.076 78.3661 177.237C82.6021 172.196 87.9476 168.97 94.4024 167.559V120.981L53.8578 144.27C54.2612 145.278 54.5638 146.488 54.7655 147.899C54.9672 149.311 55.0681 150.924 55.0681 152.738C55.0681 160.199 52.4458 166.651 47.2012 172.095C41.9566 177.54 35.5018 180.262 27.8366 180.262C20.3732 180.262 13.8174 177.54 8.16944 172.095C2.72315 166.651 0 160.199 0 152.738C0 145.278 2.62229 138.826 7.86687 133.381C13.3132 127.937 19.8689 125.215 27.534 125.215C35.8043 125.215 42.6626 128.24 48.1089 134.289L88.351 111L48.1089 87.7112C43.0661 93.7602 36.3086 96.7847 27.8366 96.7847C20.1715 96.7847 13.6157 94.1635 8.16944 88.921C2.72315 83.4768 0 77.0245 0 69.564C0 61.9019 2.72315 55.3488 8.16944 49.9046C13.8174 44.4605 20.3732 41.7384 27.8366 41.7384C35.5018 41.7384 41.9566 44.5613 47.2012 50.2071C52.4458 55.6512 55.0681 62.0027 55.0681 69.2616C55.0681 71.0763 54.9672 72.6894 54.7655 74.1008C54.5638 75.5123 54.2612 76.7221 53.8578 77.7302L94.4024 101.019V54.4414C88.1493 53.2316 82.9047 50.2071 78.6687 45.3679C74.4327 40.327 72.3147 34.3787 72.3147 27.5232C72.3147 19.861 75.0378 13.4087 80.4841 8.16621C85.9304 2.72207 92.3853 0 99.8487 0C107.716 0 114.271 2.72207 119.516 8.16621C124.962 13.6104 127.685 20.0627 127.685 27.5232C127.685 34.1771 125.567 40.0245 121.331 45.0654C117.095 50.1063 111.851 53.2316 105.598 54.4414V101.019L146.142 77.7302C145.335 75.5123 144.932 72.6894 144.932 69.2616C144.932 61.8011 147.554 55.3488 152.799 49.9046C158.043 44.4605 164.498 41.7384 172.163 41.7384C180.232 41.7384 186.889 44.5613 192.133 50.2071C197.378 55.6512 200 62.1035 200 69.564C200 77.0245 197.277 83.4768 191.831 88.921C186.384 94.1635 179.829 96.7847 172.163 96.7847C163.893 96.7847 157.136 93.7602 151.891 87.7112L111.346 111L151.891 134.289C157.337 128.24 164.196 125.215 172.466 125.215C180.131 125.215 186.586 127.937 191.831 133.381C197.277 138.826 200 145.278 200 152.738C200 160.199 197.277 166.651 191.831 172.095C186.384 177.54 179.829 180.262 172.163 180.262C164.498 180.262 158.043 177.54 152.799 172.095C147.554 166.651 144.932 160.199 144.932 152.738C144.932 149.311 145.335 146.488 146.142 144.27L105.598 120.981V167.559C112.052 168.97 117.297 172.196 121.331 177.237C125.567 182.278 127.685 188.025 127.685 194.477C127.685 202.341 124.962 208.894 119.516 214.136C114.271 219.379 107.816 222 100.151 222Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M100.151 222C92.4861 222 85.9304 219.379 80.4841 214.136C75.0378 208.894 72.3147 202.341 72.3147 194.477C72.3147 187.823 74.3318 182.076 78.3661 177.237C82.6021 172.196 87.9476 168.97 94.4024 167.559V120.981L53.8578 144.27C54.2612 145.278 54.5638 146.488 54.7655 147.899C54.9672 149.311 55.0681 150.924 55.0681 152.738C55.0681 160.199 52.4458 166.651 47.2012 172.095C41.9566 177.54 35.5018 180.262 27.8366 180.262C20.3732 180.262 13.8174 177.54 8.16944 172.095C2.72315 166.651 0 160.199 0 152.738C0 145.278 2.62229 138.826 7.86687 133.381C13.3132 127.937 19.8689 125.215 27.534 125.215C35.8043 125.215 42.6626 128.24 48.1089 134.289L88.351 111L48.1089 87.7112C43.0661 93.7602 36.3086 96.7847 27.8366 96.7847C20.1715 96.7847 13.6157 94.1635 8.16944 88.921C2.72315 83.4768 0 77.0245 0 69.564C0 61.9019 2.72315 55.3488 8.16944 49.9046C13.8174 44.4605 20.3732 41.7384 27.8366 41.7384C35.5018 41.7384 41.9566 44.5613 47.2012 50.2071C52.4458 55.6512 55.0681 62.0027 55.0681 69.2616C55.0681 71.0763 54.9672 72.6894 54.7655 74.1008C54.5638 75.5123 54.2612 76.7221 53.8578 77.7302L94.4024 101.019V54.4414C88.1493 53.2316 82.9047 50.2071 78.6687 45.3679C74.4327 40.327 72.3147 34.3787 72.3147 27.5232C72.3147 19.861 75.0378 13.4087 80.4841 8.16621C85.9304 2.72207 92.3853 0 99.8487 0C107.716 0 114.271 2.72207 119.516 8.16621C124.962 13.6104 127.685 20.0627 127.685 27.5232C127.685 34.1771 125.567 40.0245 121.331 45.0654C117.095 50.1063 111.851 53.2316 105.598 54.4414V101.019L146.142 77.7302C145.335 75.5123 144.932 72.6894 144.932 69.2616C144.932 61.8011 147.554 55.3488 152.799 49.9046C158.043 44.4605 164.498 41.7384 172.163 41.7384C180.232 41.7384 186.889 44.5613 192.133 50.2071C197.378 55.6512 200 62.1035 200 69.564C200 77.0245 197.277 83.4768 191.831 88.921C186.384 94.1635 179.829 96.7847 172.163 96.7847C163.893 96.7847 157.136 93.7602 151.891 87.7112L111.346 111L151.891 134.289C157.337 128.24 164.196 125.215 172.466 125.215C180.131 125.215 186.586 127.937 191.831 133.381C197.277 138.826 200 145.278 200 152.738C200 160.199 197.277 166.651 191.831 172.095C186.384 177.54 179.829 180.262 172.163 180.262C164.498 180.262 158.043 177.54 152.799 172.095C147.554 166.651 144.932 160.199 144.932 152.738C144.932 149.311 145.335 146.488 146.142 144.27L105.598 120.981V167.559C112.052 168.97 117.297 172.196 121.331 177.237C125.567 182.278 127.685 188.025 127.685 194.477C127.685 202.341 124.962 208.894 119.516 214.136C114.271 219.379 107.816 222 100.151 222Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="200" viewBox="0 0 200 200" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M99.726 200C86.0274 200 73.1507 197.443 61.0959 192.329C49.0411 187.032 38.4475 179.817 29.3151 170.685C20.1826 161.37 12.968 150.685 7.67123 138.63C2.55708 126.575 0 113.607 0 99.726C0 85.6621 2.55708 72.6027 7.67123 60.5479C12.968 48.3105 20.1826 37.7169 29.3151 28.7671C38.4475 19.6347 49.0411 12.6027 61.0959 7.67123C73.1507 2.55708 86.0274 0 99.726 0C113.79 0 126.849 2.64841 138.904 7.94522C151.142 13.0594 161.826 20.274 170.959 29.589C180.091 38.7215 187.215 49.3151 192.329 61.3699C197.443 73.242 200 86.0274 200 99.726C200 113.607 197.352 126.575 192.055 138.63C186.941 150.685 179.817 161.37 170.685 170.685C161.553 179.817 150.868 187.032 138.63 192.329C126.575 197.443 113.607 200 99.726 200ZM45.4795 173.151L99.726 133.699L154.521 173.151L133.699 111.233L184.11 77.2603H122.192L99.726 10.411L77.8082 77.2603H15.8904L66.3014 111.233L45.4795 173.151Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M99.726 200C86.0274 200 73.1507 197.443 61.0959 192.329C49.0411 187.032 38.4475 179.817 29.3151 170.685C20.1826 161.37 12.968 150.685 7.67123 138.63C2.55708 126.575 0 113.607 0 99.726C0 85.6621 2.55708 72.6027 7.67123 60.5479C12.968 48.3105 20.1826 37.7169 29.3151 28.7671C38.4475 19.6347 49.0411 12.6027 61.0959 7.67123C73.1507 2.55708 86.0274 0 99.726 0C113.79 0 126.849 2.64841 138.904 7.94522C151.142 13.0594 161.826 20.274 170.959 29.589C180.091 38.7215 187.215 49.3151 192.329 61.3699C197.443 73.242 200 86.0274 200 99.726C200 113.607 197.352 126.575 192.055 138.63C186.941 150.685 179.817 161.37 170.685 170.685C161.553 179.817 150.868 187.032 138.63 192.329C126.575 197.443 113.607 200 99.726 200ZM45.4795 173.151L99.726 133.699L154.521 173.151L133.699 111.233L184.11 77.2603H122.192L99.726 10.411L77.8082 77.2603H15.8904L66.3014 111.233L45.4795 173.151Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="222" viewBox="0 0 200 222" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M100.309 222C93.5185 222 88.2716 220.253 84.5679 216.758C81.07 213.264 79.321 208.536 79.321 202.575V201.65C79.5267 197.333 80.2469 192.297 81.4815 186.542C82.9218 180.786 84.5679 175.031 86.4198 169.275C88.2716 163.519 89.8148 158.689 91.0494 154.783L92.2839 149.233C92.2839 147.589 91.358 146.458 89.5062 145.842L85.4938 144.3C82.2016 143.272 79.4239 141.731 77.1605 139.675C74.8971 137.414 73.4568 136.283 72.8395 136.283C71.6049 136.283 69.6502 137.928 66.9753 141.217L60.8025 147.692L43.5185 165.575C39.6091 169.481 35.6996 172.564 31.7901 174.825C28.0864 177.086 24.3827 178.217 20.679 178.217C15.535 178.217 10.8025 175.75 6.48148 170.817C2.36625 165.678 0.308641 160.231 0.308641 154.475C0.308641 149.747 2.57202 145.431 7.09876 141.525C11.214 138.031 20.2675 134.536 34.2593 131.042C41.2551 129.397 46.8107 128.061 50.9259 127.033C55.0411 126.006 57.9218 125.286 59.5679 124.875C62.6543 123.847 64.1975 122.511 64.1975 120.867L63.5802 116.55L63.2716 111C63.2716 109.15 63.5802 107.506 64.1975 106.067C64.4033 105.244 64.5062 104.525 64.5062 103.908C64.7119 103.086 64.8148 102.264 64.8148 101.442C64.8148 100.003 64.4033 99.1806 63.5802 98.975C62.963 98.5639 62.1399 98.1528 61.1111 97.7417C60.2881 97.3306 59.1564 97.0222 57.716 96.8167L23.7654 88.1833C16.358 86.3333 10.4938 83.6611 6.17284 80.1667C2.05761 76.4667 0 72.3556 0 67.8333C0 64.75 0.925926 61.3583 2.77778 57.6583C4.62963 53.7528 7.09877 50.4639 10.1852 47.7917C13.4774 45.1194 16.8724 43.7833 20.3704 43.7833C24.0741 43.7833 28.3951 45.325 33.3333 48.4083C38.0658 51.4917 44.5473 57.35 52.7778 65.9833L66.9753 80.7833C69.856 83.8667 71.8107 85.4083 72.8395 85.4083C73.8683 85.4083 75.5144 84.2778 77.7778 82.0167C79.8354 79.9611 82.8189 78.3167 86.7284 77.0833C90.4321 75.85 92.2839 74.4111 92.2839 72.7667L91.0494 67.2167C90.0206 64.3389 88.5802 60.0222 86.7284 54.2667C85.0823 48.5111 83.4362 42.55 81.7901 36.3833C80.3498 30.0111 79.5267 24.6667 79.321 20.35V19.425C79.321 13.4639 81.07 8.73612 84.5679 5.24167C88.2716 1.74722 93.5185 0 100.309 0C113.889 0 120.679 6.475 120.679 19.425V20.35C120.473 23.6389 119.959 27.5444 119.136 32.0667C118.313 36.5889 116.975 41.7278 115.123 47.4833L108.951 67.2167L107.716 72.7667C107.716 74.6167 109.671 76.1583 113.58 77.3917C115.638 78.0083 117.387 78.7278 118.827 79.55C120.267 80.1667 121.502 81.0917 122.531 82.325C124.383 84.3806 126.029 85.4083 127.469 85.4083C128.909 85.4083 130.967 83.8667 133.642 80.7833L139.506 74.3083C145.062 68.3472 149.897 63.3111 154.012 59.2C158.128 55.0889 161.626 52.0056 164.506 49.95C170.473 45.8389 175.514 43.7833 179.63 43.7833C183.333 43.7833 186.728 45.1194 189.815 47.7917C192.901 50.4639 195.37 53.65 197.222 57.35C199.074 61.05 200 64.5444 200 67.8333C200 72.3556 197.84 76.3639 193.519 79.8583C189.403 83.3528 183.642 86.1278 176.235 88.1833L162.654 91.8833C155.247 93.9389 149.383 95.4806 145.062 96.5083C140.947 97.3306 138.477 97.9472 137.654 98.3583C136.008 99.3861 135.185 100.414 135.185 101.442C135.185 103.086 135.494 104.525 136.111 105.758C136.523 107.403 136.728 109.15 136.728 111C136.728 112.85 136.523 114.597 136.111 116.242C135.905 116.858 135.7 117.578 135.494 118.4C135.494 119.017 135.494 119.839 135.494 120.867C135.494 122.717 137.757 124.156 142.284 125.183L150.926 127.342C151.337 127.547 153.601 128.164 157.716 129.192C162.037 130.014 168.21 131.556 176.235 133.817C191.872 138.133 199.691 145.019 199.691 154.475C199.691 160.231 197.634 165.678 193.519 170.817C189.609 175.75 184.979 178.217 179.63 178.217C175.926 178.217 171.708 176.675 166.975 173.592C164.712 171.947 161.831 169.686 158.333 166.808C155.041 163.931 151.337 160.333 147.222 156.017L133.025 141.217C130.35 137.928 128.395 136.283 127.16 136.283C126.337 136.283 124.794 137.414 122.531 139.675C121.296 140.908 119.959 141.936 118.519 142.758C117.078 143.581 115.329 144.197 113.272 144.608C109.568 145.842 107.716 147.383 107.716 149.233L108.951 154.783C109.979 157.661 111.317 162.081 112.963 168.042C114.815 173.797 116.461 179.758 117.901 185.925C119.547 192.092 120.473 197.333 120.679 201.65V202.575C120.679 215.525 113.889 222 100.309 222ZM100.309 133.817C106.687 133.817 112.037 131.658 116.358 127.342C120.885 123.025 123.148 117.578 123.148 111C123.148 104.628 120.885 99.2833 116.358 94.9667C112.037 90.4445 106.687 88.1833 100.309 88.1833C93.93 88.1833 88.4774 90.4445 83.9506 94.9667C79.6296 99.2833 77.4691 104.628 77.4691 111C77.4691 117.372 79.6296 122.819 83.9506 127.342C88.4774 131.658 93.93 133.817 100.309 133.817Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M100.309 222C93.5185 222 88.2716 220.253 84.5679 216.758C81.07 213.264 79.321 208.536 79.321 202.575V201.65C79.5267 197.333 80.2469 192.297 81.4815 186.542C82.9218 180.786 84.5679 175.031 86.4198 169.275C88.2716 163.519 89.8148 158.689 91.0494 154.783L92.2839 149.233C92.2839 147.589 91.358 146.458 89.5062 145.842L85.4938 144.3C82.2016 143.272 79.4239 141.731 77.1605 139.675C74.8971 137.414 73.4568 136.283 72.8395 136.283C71.6049 136.283 69.6502 137.928 66.9753 141.217L60.8025 147.692L43.5185 165.575C39.6091 169.481 35.6996 172.564 31.7901 174.825C28.0864 177.086 24.3827 178.217 20.679 178.217C15.535 178.217 10.8025 175.75 6.48148 170.817C2.36625 165.678 0.308641 160.231 0.308641 154.475C0.308641 149.747 2.57202 145.431 7.09876 141.525C11.214 138.031 20.2675 134.536 34.2593 131.042C41.2551 129.397 46.8107 128.061 50.9259 127.033C55.0411 126.006 57.9218 125.286 59.5679 124.875C62.6543 123.847 64.1975 122.511 64.1975 120.867L63.5802 116.55L63.2716 111C63.2716 109.15 63.5802 107.506 64.1975 106.067C64.4033 105.244 64.5062 104.525 64.5062 103.908C64.7119 103.086 64.8148 102.264 64.8148 101.442C64.8148 100.003 64.4033 99.1806 63.5802 98.975C62.963 98.5639 62.1399 98.1528 61.1111 97.7417C60.2881 97.3306 59.1564 97.0222 57.716 96.8167L23.7654 88.1833C16.358 86.3333 10.4938 83.6611 6.17284 80.1667C2.05761 76.4667 0 72.3556 0 67.8333C0 64.75 0.925926 61.3583 2.77778 57.6583C4.62963 53.7528 7.09877 50.4639 10.1852 47.7917C13.4774 45.1194 16.8724 43.7833 20.3704 43.7833C24.0741 43.7833 28.3951 45.325 33.3333 48.4083C38.0658 51.4917 44.5473 57.35 52.7778 65.9833L66.9753 80.7833C69.856 83.8667 71.8107 85.4083 72.8395 85.4083C73.8683 85.4083 75.5144 84.2778 77.7778 82.0167C79.8354 79.9611 82.8189 78.3167 86.7284 77.0833C90.4321 75.85 92.2839 74.4111 92.2839 72.7667L91.0494 67.2167C90.0206 64.3389 88.5802 60.0222 86.7284 54.2667C85.0823 48.5111 83.4362 42.55 81.7901 36.3833C80.3498 30.0111 79.5267 24.6667 79.321 20.35V19.425C79.321 13.4639 81.07 8.73612 84.5679 5.24167C88.2716 1.74722 93.5185 0 100.309 0C113.889 0 120.679 6.475 120.679 19.425V20.35C120.473 23.6389 119.959 27.5444 119.136 32.0667C118.313 36.5889 116.975 41.7278 115.123 47.4833L108.951 67.2167L107.716 72.7667C107.716 74.6167 109.671 76.1583 113.58 77.3917C115.638 78.0083 117.387 78.7278 118.827 79.55C120.267 80.1667 121.502 81.0917 122.531 82.325C124.383 84.3806 126.029 85.4083 127.469 85.4083C128.909 85.4083 130.967 83.8667 133.642 80.7833L139.506 74.3083C145.062 68.3472 149.897 63.3111 154.012 59.2C158.128 55.0889 161.626 52.0056 164.506 49.95C170.473 45.8389 175.514 43.7833 179.63 43.7833C183.333 43.7833 186.728 45.1194 189.815 47.7917C192.901 50.4639 195.37 53.65 197.222 57.35C199.074 61.05 200 64.5444 200 67.8333C200 72.3556 197.84 76.3639 193.519 79.8583C189.403 83.3528 183.642 86.1278 176.235 88.1833L162.654 91.8833C155.247 93.9389 149.383 95.4806 145.062 96.5083C140.947 97.3306 138.477 97.9472 137.654 98.3583C136.008 99.3861 135.185 100.414 135.185 101.442C135.185 103.086 135.494 104.525 136.111 105.758C136.523 107.403 136.728 109.15 136.728 111C136.728 112.85 136.523 114.597 136.111 116.242C135.905 116.858 135.7 117.578 135.494 118.4C135.494 119.017 135.494 119.839 135.494 120.867C135.494 122.717 137.757 124.156 142.284 125.183L150.926 127.342C151.337 127.547 153.601 128.164 157.716 129.192C162.037 130.014 168.21 131.556 176.235 133.817C191.872 138.133 199.691 145.019 199.691 154.475C199.691 160.231 197.634 165.678 193.519 170.817C189.609 175.75 184.979 178.217 179.63 178.217C175.926 178.217 171.708 176.675 166.975 173.592C164.712 171.947 161.831 169.686 158.333 166.808C155.041 163.931 151.337 160.333 147.222 156.017L133.025 141.217C130.35 137.928 128.395 136.283 127.16 136.283C126.337 136.283 124.794 137.414 122.531 139.675C121.296 140.908 119.959 141.936 118.519 142.758C117.078 143.581 115.329 144.197 113.272 144.608C109.568 145.842 107.716 147.383 107.716 149.233L108.951 154.783C109.979 157.661 111.317 162.081 112.963 168.042C114.815 173.797 116.461 179.758 117.901 185.925C119.547 192.092 120.473 197.333 120.679 201.65V202.575C120.679 215.525 113.889 222 100.309 222ZM100.309 133.817C106.687 133.817 112.037 131.658 116.358 127.342C120.885 123.025 123.148 117.578 123.148 111C123.148 104.628 120.885 99.2833 116.358 94.9667C112.037 90.4445 106.687 88.1833 100.309 88.1833C93.93 88.1833 88.4774 90.4445 83.9506 94.9667C79.6296 99.2833 77.4691 104.628 77.4691 111C77.4691 117.372 79.6296 122.819 83.9506 127.342C88.4774 131.658 93.93 133.817 100.309 133.817Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="194" viewBox="0 0 200 194" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M34.7162 194L56.7686 121.25L0 79.5225L70.7424 76.027L100 0L128.821 76.027L200 79.5225L143.231 121.25L164.629 194L100 151.617L34.7162 194ZM47.3799 177.833L100 132.392L152.402 177.833L124.891 116.007L178.821 85.8581L117.031 90.8829L100 19.6622L82.3144 90.8829L21.179 85.8581L75.1092 116.007L47.3799 177.833Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M34.7162 194L56.7686 121.25L0 79.5225L70.7424 76.027L100 0L128.821 76.027L200 79.5225L143.231 121.25L164.629 194L100 151.617L34.7162 194ZM47.3799 177.833L100 132.392L152.402 177.833L124.891 116.007L178.821 85.8581L117.031 90.8829L100 19.6622L82.3144 90.8829L21.179 85.8581L75.1092 116.007L47.3799 177.833Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="222" viewBox="0 0 200 222" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M92.1739 222L89.8551 128.099L7.53623 173.021L0 159.689L79.7102 111L0 62.0209L7.53623 48.9791L89.8551 93.611L92.1739 0H107.536L109.855 93.611L192.174 48.9791L200 62.0209L120 111L200 159.689L192.174 173.021L109.855 128.099L107.536 222H92.1739Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M92.1739 222L89.8551 128.099L7.53623 173.021L0 159.689L79.7102 111L0 62.0209L7.53623 48.9791L89.8551 93.611L92.1739 0H107.536L109.855 93.611L192.174 48.9791L200 62.0209L120 111L200 159.689L192.174 173.021L109.855 128.099L107.536 222H92.1739Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="200" viewBox="0 0 200 200" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M100 135.873C93.4391 135.873 87.4339 134.259 81.9841 131.032C76.5344 127.804 72.1958 123.466 68.9683 118.016C65.7407 112.566 64.127 106.561 64.127 100C64.127 93.3862 65.7407 87.3809 68.9683 81.9841C72.1958 76.5344 76.5344 72.1958 81.9841 68.9682C87.4339 65.7407 93.4391 64.127 100 64.127C106.614 64.127 112.619 65.7407 118.016 68.9682C123.466 72.1958 127.804 76.5344 131.032 81.9841C134.259 87.3809 135.873 93.3862 135.873 100C135.873 106.561 134.259 112.566 131.032 118.016C127.804 123.466 123.466 127.804 118.016 131.032C112.619 134.259 106.614 135.873 100 135.873ZM92.3809 48.254V0H107.619V48.254H92.3809ZM141.905 68.8889L131.111 58.0952L165.397 23.8095L176.19 34.6032L141.905 68.8889ZM151.746 107.619V92.3809H200V107.619H151.746ZM165.397 176.19L131.111 141.905L141.905 131.111L176.19 165.397L165.397 176.19ZM92.3809 200V151.746H107.619V200H92.3809ZM34.6032 176.19L23.8095 165.397L58.0952 131.111L68.8889 141.905L34.6032 176.19ZM0 107.619V92.3809H48.254V107.619H0ZM58.0952 68.8889L23.8095 34.6032L34.6032 23.8095L68.8889 58.0952L58.0952 68.8889Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M100 135.873C93.4391 135.873 87.4339 134.259 81.9841 131.032C76.5344 127.804 72.1958 123.466 68.9683 118.016C65.7407 112.566 64.127 106.561 64.127 100C64.127 93.3862 65.7407 87.3809 68.9683 81.9841C72.1958 76.5344 76.5344 72.1958 81.9841 68.9682C87.4339 65.7407 93.4391 64.127 100 64.127C106.614 64.127 112.619 65.7407 118.016 68.9682C123.466 72.1958 127.804 76.5344 131.032 81.9841C134.259 87.3809 135.873 93.3862 135.873 100C135.873 106.561 134.259 112.566 131.032 118.016C127.804 123.466 123.466 127.804 118.016 131.032C112.619 134.259 106.614 135.873 100 135.873ZM92.3809 48.254V0H107.619V48.254H92.3809ZM141.905 68.8889L131.111 58.0952L165.397 23.8095L176.19 34.6032L141.905 68.8889ZM151.746 107.619V92.3809H200V107.619H151.746ZM165.397 176.19L131.111 141.905L141.905 131.111L176.19 165.397L165.397 176.19ZM92.3809 200V151.746H107.619V200H92.3809ZM34.6032 176.19L23.8095 165.397L58.0952 131.111L68.8889 141.905L34.6032 176.19ZM0 107.619V92.3809H48.254V107.619H0ZM58.0952 68.8889L23.8095 34.6032L34.6032 23.8095L68.8889 58.0952L58.0952 68.8889Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="200" viewBox="0 0 200 200" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M100.258 200C91.8174 200 85.3575 197.588 80.8786 192.765C76.5719 188.114 74.4186 182.257 74.4186 175.194C74.4186 167.27 77.6917 157.192 84.2377 144.961C90.7838 132.558 94.9182 118.691 96.6408 103.359C84.2377 104.565 73.385 107.321 64.0827 111.628C55.814 115.418 49.354 118.26 44.7028 120.155C40.0517 122.05 36.2618 123.342 33.3333 124.031C30.4048 124.72 27.3902 125.065 24.2894 125.065C17.3988 125.065 11.6279 122.911 6.97674 118.605C2.32558 114.126 0 107.838 0 99.7416C0 91.6451 2.32558 85.4436 6.97674 81.137C11.8002 76.6581 17.5711 74.4186 24.2894 74.4186C32.9027 74.4186 43.9277 77.7778 57.3643 84.4961C70.6288 91.2145 83.7209 95.2627 96.6408 96.6408C95.435 84.2377 92.6787 73.385 88.3721 64.0827C84.41 55.4694 81.3953 48.8372 79.3282 44.186C77.4333 39.3626 76.1413 35.5728 75.4522 32.8165C74.7631 29.888 74.4186 27.0457 74.4186 24.2894C74.4186 17.3988 76.4858 11.6279 80.6202 6.97675C84.7545 2.32558 91.3006 0 100.258 0C109.044 0 115.418 2.41171 119.38 7.23514C123.514 11.8863 125.581 17.5711 125.581 24.2894C125.581 32.5581 122.308 42.8079 115.762 55.0388C109.216 67.4419 105.082 81.3092 103.359 96.6408C115.245 95.2627 126.098 92.3342 135.917 87.8553L146.77 82.6873C158.656 77.1749 168.303 74.4186 175.711 74.4186C182.601 74.4186 188.372 76.6581 193.023 81.137C197.674 85.4436 200 91.6451 200 99.7416C200 107.838 197.588 114.126 192.765 118.605C188.114 122.911 182.429 125.065 175.711 125.065C172.438 125.065 169.251 124.72 166.15 124.031C163.049 123.17 159.173 121.792 154.522 119.897C149.871 117.829 143.669 115.073 135.917 111.628C126.615 107.321 115.762 104.565 103.359 103.359C104.048 109.216 104.737 114.212 105.426 118.346C106.288 122.308 107.58 126.443 109.302 130.749C111.025 134.884 113.523 140.224 116.796 146.77C120.241 153.661 122.567 159.173 123.773 163.307C124.978 167.27 125.581 171.232 125.581 175.194C125.581 182.429 123.428 188.372 119.121 193.023C114.815 197.674 108.527 200 100.258 200Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M100.258 200C91.8174 200 85.3575 197.588 80.8786 192.765C76.5719 188.114 74.4186 182.257 74.4186 175.194C74.4186 167.27 77.6917 157.192 84.2377 144.961C90.7838 132.558 94.9182 118.691 96.6408 103.359C84.2377 104.565 73.385 107.321 64.0827 111.628C55.814 115.418 49.354 118.26 44.7028 120.155C40.0517 122.05 36.2618 123.342 33.3333 124.031C30.4048 124.72 27.3902 125.065 24.2894 125.065C17.3988 125.065 11.6279 122.911 6.97674 118.605C2.32558 114.126 0 107.838 0 99.7416C0 91.6451 2.32558 85.4436 6.97674 81.137C11.8002 76.6581 17.5711 74.4186 24.2894 74.4186C32.9027 74.4186 43.9277 77.7778 57.3643 84.4961C70.6288 91.2145 83.7209 95.2627 96.6408 96.6408C95.435 84.2377 92.6787 73.385 88.3721 64.0827C84.41 55.4694 81.3953 48.8372 79.3282 44.186C77.4333 39.3626 76.1413 35.5728 75.4522 32.8165C74.7631 29.888 74.4186 27.0457 74.4186 24.2894C74.4186 17.3988 76.4858 11.6279 80.6202 6.97675C84.7545 2.32558 91.3006 0 100.258 0C109.044 0 115.418 2.41171 119.38 7.23514C123.514 11.8863 125.581 17.5711 125.581 24.2894C125.581 32.5581 122.308 42.8079 115.762 55.0388C109.216 67.4419 105.082 81.3092 103.359 96.6408C115.245 95.2627 126.098 92.3342 135.917 87.8553L146.77 82.6873C158.656 77.1749 168.303 74.4186 175.711 74.4186C182.601 74.4186 188.372 76.6581 193.023 81.137C197.674 85.4436 200 91.6451 200 99.7416C200 107.838 197.588 114.126 192.765 118.605C188.114 122.911 182.429 125.065 175.711 125.065C172.438 125.065 169.251 124.72 166.15 124.031C163.049 123.17 159.173 121.792 154.522 119.897C149.871 117.829 143.669 115.073 135.917 111.628C126.615 107.321 115.762 104.565 103.359 103.359C104.048 109.216 104.737 114.212 105.426 118.346C106.288 122.308 107.58 126.443 109.302 130.749C111.025 134.884 113.523 140.224 116.796 146.77C120.241 153.661 122.567 159.173 123.773 163.307C124.978 167.27 125.581 171.232 125.581 175.194C125.581 182.429 123.428 188.372 119.121 193.023C114.815 197.674 108.527 200 100.258 200Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="200" viewBox="0 0 200 200" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M91.7582 200L95.6044 120.879L69.2308 195.604L53.8462 189.56L87.9121 117.582L35.1648 176.923L23.0769 164.835L82.4176 112.088L10.4396 146.154L4.3956 130.769L79.1209 104.396L0 108.242V91.7582L79.1209 96.1538L4.3956 69.2308L10.4396 54.3956L82.4176 88.4615L23.0769 35.1648L35.1648 23.6264L87.9121 82.4176L53.8462 10.989L69.2308 4.3956L95.6044 79.6703L91.7582 0H108.242L103.846 79.1209L130.769 4.3956L145.604 10.989L111.538 82.4176L164.835 23.6264L176.374 35.1648L117.582 88.4615L189.011 54.3956L195.604 69.2308L120.33 96.1538L200 91.7582V108.242L120.33 104.396L195.604 130.769L189.011 146.154L117.582 112.088L176.374 164.835L164.835 176.923L111.538 117.582L145.604 189.56L130.769 195.604L103.846 120.879L108.242 200H91.7582Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M91.7582 200L95.6044 120.879L69.2308 195.604L53.8462 189.56L87.9121 117.582L35.1648 176.923L23.0769 164.835L82.4176 112.088L10.4396 146.154L4.3956 130.769L79.1209 104.396L0 108.242V91.7582L79.1209 96.1538L4.3956 69.2308L10.4396 54.3956L82.4176 88.4615L23.0769 35.1648L35.1648 23.6264L87.9121 82.4176L53.8462 10.989L69.2308 4.3956L95.6044 79.6703L91.7582 0H108.242L103.846 79.1209L130.769 4.3956L145.604 10.989L111.538 82.4176L164.835 23.6264L176.374 35.1648L117.582 88.4615L189.011 54.3956L195.604 69.2308L120.33 96.1538L200 91.7582V108.242L120.33 104.396L195.604 130.769L189.011 146.154L117.582 112.088L176.374 164.835L164.835 176.923L111.538 117.582L145.604 189.56L130.769 195.604L103.846 120.879L108.242 200H91.7582Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="199" viewBox="0 0 200 199" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M97.1722 199L84.8329 136.428L31.3625 171.817L27.2494 168.227L62.7249 114.887L0 102.577V96.9356L62.7249 84.1134L27.2494 31.2861L31.3625 27.183L84.8329 62.5722L97.1722 0H102.828L115.167 62.5722L168.638 27.183L172.751 31.2861L137.275 84.1134L200 96.9356V102.577L137.275 114.887L172.751 168.227L168.638 171.817L115.167 136.428L102.828 199H97.1722ZM99.7429 91.2938V13.8479L88.946 66.6753L99.7429 91.2938ZM94.0874 93.8583L39.0746 38.9794L68.8946 84.1134L94.0874 93.8583ZM105.913 93.8583L160.925 38.9794L115.167 68.7268L105.913 93.8583ZM107.969 99.5H186.118L132.648 88.7294L107.969 99.5ZM67.3522 110.784L92.0308 99.5H13.8817L67.3522 110.784ZM39.0746 160.021L84.8329 130.786L94.0874 105.142L39.0746 160.021ZM160.925 160.021L131.105 114.887L105.913 105.142L160.925 160.021ZM99.7429 185.152L111.054 132.325L99.7429 107.706V185.152Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M97.1722 199L84.8329 136.428L31.3625 171.817L27.2494 168.227L62.7249 114.887L0 102.577V96.9356L62.7249 84.1134L27.2494 31.2861L31.3625 27.183L84.8329 62.5722L97.1722 0H102.828L115.167 62.5722L168.638 27.183L172.751 31.2861L137.275 84.1134L200 96.9356V102.577L137.275 114.887L172.751 168.227L168.638 171.817L115.167 136.428L102.828 199H97.1722ZM99.7429 91.2938V13.8479L88.946 66.6753L99.7429 91.2938ZM94.0874 93.8583L39.0746 38.9794L68.8946 84.1134L94.0874 93.8583ZM105.913 93.8583L160.925 38.9794L115.167 68.7268L105.913 93.8583ZM107.969 99.5H186.118L132.648 88.7294L107.969 99.5ZM67.3522 110.784L92.0308 99.5H13.8817L67.3522 110.784ZM39.0746 160.021L84.8329 130.786L94.0874 105.142L39.0746 160.021ZM160.925 160.021L131.105 114.887L105.913 105.142L160.925 160.021ZM99.7429 185.152L111.054 132.325L99.7429 107.706V185.152Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="200" viewBox="0 0 200 200" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M99.8621 200C86.2529 200 73.3793 197.422 61.2414 192.265C49.2874 187.109 38.7126 180.018 29.5172 170.994C20.3218 161.786 13.0575 151.105 7.72414 138.95C2.57471 126.796 0 113.812 0 100C0 86.372 2.57471 73.5727 7.72414 61.6022C12.8736 49.4475 20.046 38.7661 29.2414 29.558C38.4368 20.3499 49.0115 13.1676 60.9655 8.01105C73.1035 2.67035 86.069 0 99.8621 0C113.655 0 126.529 2.57827 138.483 7.73481C150.621 12.8913 161.287 20.0737 170.483 29.2818C179.678 38.4899 186.851 49.1713 192 61.326C197.333 73.2965 200 86.1878 200 100C200 114.18 197.333 127.348 192 139.503C186.851 151.657 179.678 162.247 170.483 171.271C161.287 180.295 150.621 187.385 138.483 192.541C126.345 197.514 113.471 200 99.8621 200ZM82.2069 47.7901C88.2759 45.7643 94.1609 44.7514 99.8621 44.7514C105.195 44.7514 111.08 45.7643 117.517 47.7901L99.8621 6.90607L82.2069 47.7901ZM50.2069 75.6906C56.092 64.0884 64.4598 55.709 75.3103 50.5525L34.2069 34.2541L50.2069 75.6906ZM149.241 75.6906L165.517 34.2541L124.138 50.5525C135.172 55.709 143.54 64.0884 149.241 75.6906ZM99.8621 148.343C108.69 148.343 116.782 146.133 124.138 141.713C131.494 137.293 137.287 131.4 141.517 124.033C145.931 116.667 148.138 108.656 148.138 100C148.138 91.3444 145.931 83.3333 141.517 75.9669C137.287 68.6004 131.494 62.7072 124.138 58.2873C116.782 53.8674 108.69 51.6575 99.8621 51.6575C91.0345 51.6575 82.9425 53.8674 75.5862 58.2873C68.2299 62.7072 62.3448 68.6004 57.931 75.9669C53.7011 83.3333 51.5862 91.3444 51.5862 100C51.5862 108.656 53.7011 116.667 57.931 124.033C62.3448 131.4 68.2299 137.293 75.5862 141.713C82.9425 146.133 91.0345 148.343 99.8621 148.343ZM47.4483 117.68C45.6092 112.891 44.6897 106.998 44.6897 100C44.6897 93.186 45.6092 87.2928 47.4483 82.3204L6.89655 100L47.4483 117.68ZM152 117.68L192.828 100L152 82.3204C154.023 88.3978 155.034 94.291 155.034 100C155.034 105.709 154.023 111.602 152 117.68ZM34.2069 165.746L75.3103 149.724C64.2759 144.015 55.908 135.635 50.2069 124.586L34.2069 165.746ZM165.517 165.746L149.241 124.586C143.54 136.004 135.172 144.383 124.138 149.724L165.517 165.746ZM99.8621 193.094L117.517 152.486C112.552 154.328 106.667 155.249 99.8621 155.249C93.4253 155.249 87.5402 154.328 82.2069 152.486L99.8621 193.094Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M99.8621 200C86.2529 200 73.3793 197.422 61.2414 192.265C49.2874 187.109 38.7126 180.018 29.5172 170.994C20.3218 161.786 13.0575 151.105 7.72414 138.95C2.57471 126.796 0 113.812 0 100C0 86.372 2.57471 73.5727 7.72414 61.6022C12.8736 49.4475 20.046 38.7661 29.2414 29.558C38.4368 20.3499 49.0115 13.1676 60.9655 8.01105C73.1035 2.67035 86.069 0 99.8621 0C113.655 0 126.529 2.57827 138.483 7.73481C150.621 12.8913 161.287 20.0737 170.483 29.2818C179.678 38.4899 186.851 49.1713 192 61.326C197.333 73.2965 200 86.1878 200 100C200 114.18 197.333 127.348 192 139.503C186.851 151.657 179.678 162.247 170.483 171.271C161.287 180.295 150.621 187.385 138.483 192.541C126.345 197.514 113.471 200 99.8621 200ZM82.2069 47.7901C88.2759 45.7643 94.1609 44.7514 99.8621 44.7514C105.195 44.7514 111.08 45.7643 117.517 47.7901L99.8621 6.90607L82.2069 47.7901ZM50.2069 75.6906C56.092 64.0884 64.4598 55.709 75.3103 50.5525L34.2069 34.2541L50.2069 75.6906ZM149.241 75.6906L165.517 34.2541L124.138 50.5525C135.172 55.709 143.54 64.0884 149.241 75.6906ZM99.8621 148.343C108.69 148.343 116.782 146.133 124.138 141.713C131.494 137.293 137.287 131.4 141.517 124.033C145.931 116.667 148.138 108.656 148.138 100C148.138 91.3444 145.931 83.3333 141.517 75.9669C137.287 68.6004 131.494 62.7072 124.138 58.2873C116.782 53.8674 108.69 51.6575 99.8621 51.6575C91.0345 51.6575 82.9425 53.8674 75.5862 58.2873C68.2299 62.7072 62.3448 68.6004 57.931 75.9669C53.7011 83.3333 51.5862 91.3444 51.5862 100C51.5862 108.656 53.7011 116.667 57.931 124.033C62.3448 131.4 68.2299 137.293 75.5862 141.713C82.9425 146.133 91.0345 148.343 99.8621 148.343ZM47.4483 117.68C45.6092 112.891 44.6897 106.998 44.6897 100C44.6897 93.186 45.6092 87.2928 47.4483 82.3204L6.89655 100L47.4483 117.68ZM152 117.68L192.828 100L152 82.3204C154.023 88.3978 155.034 94.291 155.034 100C155.034 105.709 154.023 111.602 152 117.68ZM34.2069 165.746L75.3103 149.724C64.2759 144.015 55.908 135.635 50.2069 124.586L34.2069 165.746ZM165.517 165.746L149.241 124.586C143.54 136.004 135.172 144.383 124.138 149.724L165.517 165.746ZM99.8621 193.094L117.517 152.486C112.552 154.328 106.667 155.249 99.8621 155.249C93.4253 155.249 87.5402 154.328 82.2069 152.486L99.8621 193.094Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="194" viewBox="0 0 200 194" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M35.3535 194L60.101 119.734L0 79.8229H73.7374L100 0L126.768 79.8229H200L139.899 119.734L165.152 194L100 146.51L35.3535 194ZM100 102.557V16.6719L80.303 80.3281L100 102.557ZM103.03 106.094L182.323 84.875L122.222 85.8854L103.03 106.094ZM67.6768 116.198L96.9697 106.599L18.6869 85.3802L67.6768 116.198ZM154.545 179.854L132.828 119.734L103.03 109.63L154.545 179.854ZM48.4848 176.318L100 138.427V110.135L48.4848 176.318Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M35.3535 194L60.101 119.734L0 79.8229H73.7374L100 0L126.768 79.8229H200L139.899 119.734L165.152 194L100 146.51L35.3535 194ZM100 102.557V16.6719L80.303 80.3281L100 102.557ZM103.03 106.094L182.323 84.875L122.222 85.8854L103.03 106.094ZM67.6768 116.198L96.9697 106.599L18.6869 85.3802L67.6768 116.198ZM154.545 179.854L132.828 119.734L103.03 109.63L154.545 179.854ZM48.4848 176.318L100 138.427V110.135L48.4848 176.318Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="212" viewBox="0 0 200 212" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M83.1395 76.8791V0H116.86V76.8791H83.1395ZM66.2791 106L0 67.5604L16.8605 38.4396L82.8488 76.8791L66.2791 106ZM133.14 106L116.86 77.1703L183.14 38.4396L200 67.5604L133.14 106ZM183.14 173.56L116.279 135.121L133.14 106.291L200 144.44L183.14 173.56ZM16.8605 173.56L0 144.44L66.2791 106.291L83.1395 135.121L16.8605 173.56ZM83.1395 212V135.412H116.279V212H83.1395Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M83.1395 76.8791V0H116.86V76.8791H83.1395ZM66.2791 106L0 67.5604L16.8605 38.4396L82.8488 76.8791L66.2791 106ZM133.14 106L116.86 77.1703L183.14 38.4396L200 67.5604L133.14 106ZM183.14 173.56L116.279 135.121L133.14 106.291L200 144.44L183.14 173.56ZM16.8605 173.56L0 144.44L66.2791 106.291L83.1395 135.121L16.8605 173.56ZM83.1395 212V135.412H116.279V212H83.1395Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="201" height="200" viewBox="0 0 201 200" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M200.751 160.436L161.517 199.528L104.288 142.088L59.2169 197.358H0.756104V141.976H104.174L2.41083 39.8442L41.6442 0.751819L145.371 104.856V0.437149H200.756V160.436H200.751Z"/></svg>',
                'attrs' => [
                    'data' =>
                        'M200.751 160.436L161.517 199.528L104.288 142.088L59.2169 197.358H0.756104V141.976H104.174L2.41083 39.8442L41.6442 0.751819L145.371 104.856V0.437149H200.756V160.436H200.751Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="61" viewBox="0 0 200 61" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M0.189392 8.67452C0.189392 4.17526 3.83677 0.527885 8.33602 0.527885H166.826C168.76 0.527885 170.631 1.21574 172.104 2.46846L196.842 23.5052C200.103 26.2785 200.661 31.1028 198.12 34.5477L181.486 57.0953C179.95 59.1772 177.517 60.4057 174.93 60.4057H8.33602C3.83677 60.4057 0.189392 56.7584 0.189392 52.259V8.67452Z"/></svg>',
                'attrs' => [
                    'data' =>
                        'M0.189392 8.67452C0.189392 4.17526 3.83677 0.527885 8.33602 0.527885H166.826C168.76 0.527885 170.631 1.21574 172.104 2.46846L196.842 23.5052C200.103 26.2785 200.661 31.1028 198.12 34.5477L181.486 57.0953C179.95 59.1772 177.517 60.4057 174.93 60.4057H8.33602C3.83677 60.4057 0.189392 56.7584 0.189392 52.259V8.67452Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="304" viewBox="0 0 200 304" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M124.757 304L61.6505 168.026L0 253.981V0L200 157.342H92.7184L154.854 289.917L124.757 304Z"/> </svg>',
                'attrs' => [
                    'data' => 'M124.757 304L61.6505 168.026L0 253.981V0L200 157.342H92.7184L154.854 289.917L124.757 304Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="198" height="146" viewBox="0 0 198 146" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M186.919 62.0164C160.182 62.0164 135.814 37.7629 135.814 11.129V0.208969H113.88V11.129C113.88 30.501 122.412 48.6719 135.803 62.0164H0.483215V83.8564H135.803C122.412 97.2005 113.88 115.371 113.88 134.744V145.664H135.814V134.744C135.814 108.11 160.182 83.8564 186.919 83.8564H197.886V62.0164H186.919Z"/></svg>',
                'attrs' => [
                    'data' =>
                        'M186.919 62.0164C160.182 62.0164 135.814 37.7629 135.814 11.129V0.208969H113.88V11.129C113.88 30.501 122.412 48.6719 135.803 62.0164H0.483215V83.8564H135.803C122.412 97.2005 113.88 115.371 113.88 134.744V145.664H135.814V134.744C135.814 108.11 160.182 83.8564 186.919 83.8564H197.886V62.0164H186.919Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="182" viewBox="0 0 200 182" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M197.291 69.8457C207.391 106.123 188.109 146.82 158.358 167.076C128.607 187.333 88.5721 187.149 54.4139 165.419C20.2556 143.689 -8.026 100.23 2.07456 64.1371C11.9915 27.8597 60.2905 -1.41993 103.998 0.0532601C147.89 1.52645 187.19 33.5684 197.291 69.8457Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M197.291 69.8457C207.391 106.123 188.109 146.82 158.358 167.076C128.607 187.333 88.5721 187.149 54.4139 165.419C20.2556 143.689 -8.026 100.23 2.07456 64.1371C11.9915 27.8597 60.2905 -1.41993 103.998 0.0532601C147.89 1.52645 187.19 33.5684 197.291 69.8457Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="216" height="180" viewBox="0 0 216 180" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M148.856 31.3127C173.168 48.1213 191.408 62.475 203.444 85.9865C215.435 109.521 221.311 142.279 207.609 158.059C193.928 173.771 160.736 172.527 124.919 175.479C89.146 178.407 50.7923 185.509 27.3508 168.538C3.90943 151.566 -4.57513 110.499 3.99365 74.4153C12.5398 38.2873 38.1392 7.14355 66.1631 1.21432C94.1198 -4.73674 124.568 14.5486 148.856 31.3127Z" /></svg>',
                'attrs' => [
                    'data' =>
                        'M148.856 31.3127C173.168 48.1213 191.408 62.475 203.444 85.9865C215.435 109.521 221.311 142.279 207.609 158.059C193.928 173.771 160.736 172.527 124.919 175.479C89.146 178.407 50.7923 185.509 27.3508 168.538C3.90943 151.566 -4.57513 110.499 3.99365 74.4153C12.5398 38.2873 38.1392 7.14355 66.1631 1.21432C94.1198 -4.73674 124.568 14.5486 148.856 31.3127Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="186" viewBox="0 0 200 186" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M77.0115 109.074L125.287 76.9259L77.0115 44.7778V109.074ZM0 186V17.2222C0 12.2469 1.62835 8.13272 4.88506 4.87963C8.14176 1.62654 12.2605 0 17.2414 0H182.759C187.739 0 191.858 1.62654 195.115 4.87963C198.372 8.13272 200 12.2469 200 17.2222V136.63C200 141.605 198.372 145.719 195.115 148.972C191.858 152.225 187.739 153.852 182.759 153.852H32.1839L0 186Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M77.0115 109.074L125.287 76.9259L77.0115 44.7778V109.074ZM0 186V17.2222C0 12.2469 1.62835 8.13272 4.88506 4.87963C8.14176 1.62654 12.2605 0 17.2414 0H182.759C187.739 0 191.858 1.62654 195.115 4.87963C198.372 8.13272 200 12.2469 200 17.2222V136.63C200 141.605 198.372 145.719 195.115 148.972C191.858 152.225 187.739 153.852 182.759 153.852H32.1839L0 186Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="176" viewBox="0 0 200 176" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M100 176L93.6782 170.248C75.0958 153.185 59.7222 138.614 47.5575 126.536C35.3927 114.458 25.8142 103.865 18.8218 94.7582C11.8295 85.6514 6.94444 77.4553 4.16667 70.1699C1.38889 62.8845 0 55.5991 0 48.3137C0 34.7015 4.64559 23.2462 13.9368 13.9477C23.228 4.64924 34.6743 0 48.2759 0C58.4291 0 67.9119 2.73203 76.7241 8.19608C85.5364 13.6601 93.295 21.6645 100 32.2092C106.705 21.6645 114.464 13.6601 123.276 8.19608C132.088 2.73203 141.571 0 151.724 0C165.326 0 176.772 4.64924 186.063 13.9477C195.354 23.2462 200 34.7015 200 48.3137C200 55.5991 198.611 62.8845 195.833 70.1699C193.056 77.4553 188.171 85.6514 181.178 94.7582C174.186 103.865 164.655 114.458 152.586 126.536C140.517 138.614 125.096 153.185 106.322 170.248L100 176Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M100 176L93.6782 170.248C75.0958 153.185 59.7222 138.614 47.5575 126.536C35.3927 114.458 25.8142 103.865 18.8218 94.7582C11.8295 85.6514 6.94444 77.4553 4.16667 70.1699C1.38889 62.8845 0 55.5991 0 48.3137C0 34.7015 4.64559 23.2462 13.9368 13.9477C23.228 4.64924 34.6743 0 48.2759 0C58.4291 0 67.9119 2.73203 76.7241 8.19608C85.5364 13.6601 93.295 21.6645 100 32.2092C106.705 21.6645 114.464 13.6601 123.276 8.19608C132.088 2.73203 141.571 0 151.724 0C165.326 0 176.772 4.64924 186.063 13.9477C195.354 23.2462 200 34.7015 200 48.3137C200 55.5991 198.611 62.8845 195.833 70.1699C193.056 77.4553 188.171 85.6514 181.178 94.7582C174.186 103.865 164.655 114.458 152.586 126.536C140.517 138.614 125.096 153.185 106.322 170.248L100 176Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="200" viewBox="0 0 200 200" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M187.5 200C166.019 200 144.12 194.815 121.806 184.444C99.4907 174.074 78.7963 159.352 59.7222 140.278C40.6481 121.204 25.9259 100.509 15.5556 78.1944C5.18518 55.8796 0 33.9815 0 12.5C0 8.98148 1.2037 6.01852 3.61111 3.61111C6.01852 1.2037 8.98148 0 12.5 0H51.3889C53.9815 0 56.2037 0.925926 58.0556 2.77778C59.9074 4.62963 61.2037 6.94444 61.9444 9.72222L69.4444 44.7222C69.8148 47.3148 69.7685 49.6759 69.3056 51.8056C68.8426 53.9352 67.8704 55.7407 66.3889 57.2222L38.6111 85.2778C43.4259 93.4259 48.5185 101.019 53.8889 108.056C59.2593 115.093 65.1852 121.759 71.6667 128.056C78.5185 135.093 85.7407 141.528 93.3333 147.361C100.926 153.194 108.889 158.333 117.222 162.778L143.611 135.556C145.463 133.519 147.593 132.13 150 131.389C152.407 130.648 154.815 130.463 157.222 130.833L190.278 138.056C193.056 138.796 195.37 140.278 197.222 142.5C199.074 144.722 200 147.222 200 150V187.5C200 191.019 198.796 193.981 196.389 196.389C193.981 198.796 191.019 200 187.5 200Z"/> </svg>',
                'attrs' => [
                    'data' =>
                        'M187.5 200C166.019 200 144.12 194.815 121.806 184.444C99.4907 174.074 78.7963 159.352 59.7222 140.278C40.6481 121.204 25.9259 100.509 15.5556 78.1944C5.18518 55.8796 0 33.9815 0 12.5C0 8.98148 1.2037 6.01852 3.61111 3.61111C6.01852 1.2037 8.98148 0 12.5 0H51.3889C53.9815 0 56.2037 0.925926 58.0556 2.77778C59.9074 4.62963 61.2037 6.94444 61.9444 9.72222L69.4444 44.7222C69.8148 47.3148 69.7685 49.6759 69.3056 51.8056C68.8426 53.9352 67.8704 55.7407 66.3889 57.2222L38.6111 85.2778C43.4259 93.4259 48.5185 101.019 53.8889 108.056C59.2593 115.093 65.1852 121.759 71.6667 128.056C78.5185 135.093 85.7407 141.528 93.3333 147.361C100.926 153.194 108.889 158.333 117.222 162.778L143.611 135.556C145.463 133.519 147.593 132.13 150 131.389C152.407 130.648 154.815 130.463 157.222 130.833L190.278 138.056C193.056 138.796 195.37 140.278 197.222 142.5C199.074 144.722 200 147.222 200 150V187.5C200 191.019 198.796 193.981 196.389 196.389C193.981 198.796 191.019 200 187.5 200Z',
                ],
            ],
            [
                'type' => 'Path',
                'svg' =>
                    '<svg width="200" height="195" viewBox="0 0 200 195" fill="currentColor" xmlns="http://www.w3.org/2000/svg"><path d="M200 179.441C200 187.726 193.284 194.441 185 194.441H15C6.71573 194.441 0 187.726 0 179.441V53.2256C0 44.9413 6.71573 38.2256 15 38.2256H72.6045C80.8888 38.2256 87.6045 31.5099 87.6045 23.2256V15C87.6045 6.71573 94.3202 0 102.604 0H185C193.284 0 200 6.71573 200 15V179.441Z"/></svg>',
                'attrs' => [
                    'data' =>
                        'M200 179.441C200 187.726 193.284 194.441 185 194.441H15C6.71573 194.441 0 187.726 0 179.441V53.2256C0 44.9413 6.71573 38.2256 15 38.2256H72.6045C80.8888 38.2256 87.6045 31.5099 87.6045 23.2256V15C87.6045 6.71573 94.3202 0 102.604 0H185C193.284 0 200 6.71573 200 15V179.441Z',
                ],
            ],
        ],
    ];
@endphp

<div class="space-y-4">
    @foreach ($elements as $category_label => $category)
        <div>
            <h4 class="mb-3 border-b pb-2 text-sm">
                {{ __(str()->title($category_label)) }}
            </h4>
            <div class="grid gap-2 max-lg:grid-cols-3 sm:max-md:grid-cols-5 md:grid-cols-3 md:max-lg:grid-cols-5">
                @foreach ($category as $element)
                    <button
                        @class([
                            'flex aspect-square w-full flex-col items-center justify-center gap-2 rounded-lg border p-1 text-center text-[12px] font-medium transition-all hover:bg-primary hover:text-primary-foreground hover:shadow-xl hover:shadow-primary/5',
                            '[&_svg]:h-auto [&_svg]:max-w-full [&_svg]:aspect-square' =>
                                $category_label === 'custom',
                        ])
                        @click.prevent="const node = addNodeToStage({type: '{{ $element['type'] }}', attrs: {{ Js::from($element['attrs'] ?? [[]]) }}}); activeTool = null; $nextTick(() => container.focus())"
                        @dragstart.self="$event.dataTransfer.setData('data', JSON.stringify({type: '{{ $element['type'] }}', attrs: {{ Js::from($element['attrs'] ?? [[]]) }}}));"
                        draggable="true"
                    >
                        @if (@filled($element['icon']))
                            <x-dynamic-component
                                class="size-6"
                                :component="$element['icon']"
                            />
                        @endif
                        @if (@filled($element['svg']))
                            {!! $element['svg'] !!}
                        @endif
                        @if (@filled($element['label']))
                            {{ $element['label'] }}
                        @endif
                    </button>
                @endforeach
            </div>
        </div>
    @endforeach
</div>
