<?php

namespace App\Extensions\Midjourney\System\Http\Controllers;

use App\Extensions\Midjourney\System\Services\PiAPIService;
use App\Http\Controllers\Controller;
use App\Models\UserOpenai;
use Illuminate\Http\Request;

class MidjourneyCheckStatusController extends Controller
{
    public function __invoke(Request $request)
    {
        $data = UserOpenai::query()
            ->where('status', 'IN_QUEUE')
            ->where('response', 'PI')
            ->get();

        if ($data->isEmpty()) {
            return response()->json([]);
        }

        self::updateImages();

        return response()->json([
            'data' => UserOpenai::query()
                ->whereIn('id', $data->pluck('id')->toArray())
                ->where('status', '<>', 'IN_QUEUE')
                ->get()
                ->map(function ($item) {
                    $item->setAttribute('imgId', 'img-' . $item->response . '-' . $item->id);
                    $item->setAttribute('payloadId', 'img-' . $item->response . '-' . $item->id . '-payload');
                    $item->setAttribute('img', ThumbImage($item->output));

                    return $item;
                }),
        ]);
    }

    public static function updateImages(): void
    {
        UserOpenai::query()
            ->where('response', 'PI')
            ->where('status', 'IN_QUEUE')
            ->whereNotNull('request_id')
            ->get()
            ->each(function ($item) {

                $outputs = PiAPIService::check($item->request_id);

                if (empty($outputs)) {
                    return;
                }
                $first = true;
                foreach ($outputs ?? [] as $output) {
                    $image = PiAPIService::downloadImageToStorage($output);

                    if ($first) {
                        $item->update([
                            'output' => $image,
                            'status' => 'COMPLETED',
                        ]);
                        $first = false;
                    } else {
                        $newItem = $item->replicate();
                        $newItem->output = $image;
                        $newItem->status = 'COMPLETED';
                        $newItem->save();
                    }
                }

            });
    }
}
