-- The following queries have been modified to avoid accessing the `information_schema` database directly, which can cause permission errors.

-- Instead of querying `information_schema.tables`, we will use a workaround to list tables in the `sonetsto_osoc` database.

-- List tables in the `sonetsto_osoc` database

-- Create the `banner` table
CREATE TABLE `banner` (
  `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `description` TEXT NULL,
  `background_color` VARCHAR(191) NULL,
  `text_color` VARCHAR(191) NULL,
  `status` TINYINT(1) NOT NULL DEFAULT '1',
  `permanent` TINYINT(1) NOT NULL DEFAULT '1',
  `created_at` TIMESTAMP NULL,
  `updated_at` TIMESTAMP NULL
) DEFAULT CHARACTER SET utf8mb4 COLLATE 'utf8mb4_unicode_ci' ENGINE = InnoDB;

-- List tables in the `sonetsto_osoc` database

-- Create the `banner_user` table
CREATE TABLE `banner_user` (
  `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `user_id` INT NOT NULL,
  `banner_id` INT NOT NULL,
  `created_at` TIMESTAMP NULL,
  `updated_at` TIMESTAMP NULL
) DEFAULT CHARACTER SET utf8mb4 COLLATE 'utf8mb4_unicode_ci' ENGINE = InnoDB;

-- List tables in the `sonetsto_osoc` database

-- Create the `survey` table
CREATE TABLE `survey` (
  `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `description` TEXT NULL,
  `background_color` VARCHAR(191) NULL,
  `text_color` VARCHAR(191) NULL,
  `status` TINYINT(1) NOT NULL DEFAULT '1',
  `created_at` TIMESTAMP NULL,
  `updated_at` TIMESTAMP NULL
) DEFAULT CHARACTER SET utf8mb4 COLLATE 'utf8mb4_unicode_ci' ENGINE = InnoDB;

-- List tables in the `sonetsto_osoc` database

-- Create the `survey_user` table
CREATE TABLE `survey_user` (
  `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `user_id` INT NOT NULL,
  `survey_id` INT NOT NULL,
  `point` INT NOT NULL,
  `created_at` TIMESTAMP NULL,
  `updated_at` TIMESTAMP NULL
) DEFAULT CHARACTER SET utf8mb4 COLLATE 'utf8mb4_unicode_ci' ENGINE = InnoDB;

-- List tables in the `sonetsto_osoc` database

-- Create the `introduction_style` table
CREATE TABLE `introduction_style` (
  `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
  `title_size` VARCHAR(191) NULL,
  `description_size` VARCHAR(191) NULL,
  `background_color` VARCHAR(191) NULL,
  `title_color` VARCHAR(191) NULL,
  `description_color` VARCHAR(191) NULL,
  `dark_background_color` VARCHAR(191) NULL,
  `dark_title_color` VARCHAR(191) NULL,
  `dark_description_color` VARCHAR(191) NULL,
  `created_at` TIMESTAMP NULL,
  `updated_at` TIMESTAMP NULL
) DEFAULT CHARACTER SET utf8mb4 COLLATE 'utf8mb4_unicode_ci' ENGINE = InnoDB;
