
---------------------------------------- DoniaWeb ----------------------------------
-- ---------------------Ekr---Ekr----Ekr----Ekr----Ekr----Ekr----Ekr----------------
-- ---------------------Ekr---Ekr----Ekr----Ekr----Ekr----Ekr----Ekr----------------
-- ---------------------Ekr---Ekr----Ekr----Ekr----Ekr----Ekr----Ekr----------------
---------------------------------------- DoniaWeb ----------------------------------
-- 
--
-- Drop tables if they exist to ensure they are updated
DROP TABLE IF EXISTS `ext_chatbot_histories`;
DROP TABLE IF EXISTS `ext_chatbot_embeddings`;
DROP TABLE IF EXISTS `ext_chatbot_conversations`;
DROP TABLE IF EXISTS `ext_chatbot_channel_webhooks`;
DROP TABLE IF EXISTS `ext_chatbot_channels`;
DROP TABLE IF EXISTS `ext_chatbot_avatars`;
DROP TABLE IF EXISTS `ext_chatbots`;

CREATE TABLE `ext_chatbots` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `uuid` char(36) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `interaction_type` varchar(191) DEFAULT 'automatic_response',
  `title` varchar(191) NOT NULL,
  `bubble_message` text DEFAULT NULL,
  `welcome_message` text DEFAULT NULL,
  `connect_message` text DEFAULT NULL,
  `instructions` text DEFAULT NULL,
  `do_not_go_beyond_instructions` tinyint(1) NOT NULL DEFAULT 0,
  `language` varchar(191) DEFAULT NULL,
  `ai_model` varchar(191) NOT NULL,
  `ai_embedding_model` varchar(191) NOT NULL,
  `limit_per_minute` bigint(20) NOT NULL DEFAULT 2000,
  `show_pre_defined_questions` tinyint(1) NOT NULL DEFAULT 0,
  `pre_defined_questions` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`pre_defined_questions`)),
  `logo` longtext DEFAULT NULL COMMENT 'base 64',
  `avatar` varchar(191) DEFAULT NULL,
  `trigger_avatar_size` varchar(191) DEFAULT NULL,
  `trigger_background` varchar(191) DEFAULT NULL,
  `trigger_foreground` varchar(191) DEFAULT NULL,
  `color_mode` varchar(191) NOT NULL DEFAULT 'none',
  `color` varchar(191) DEFAULT '#017BE5',
  `show_logo` tinyint(1) NOT NULL DEFAULT 1,
  `show_date_and_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_average_response_time` tinyint(1) NOT NULL DEFAULT 1,
  `position` varchar(191) NOT NULL DEFAULT 'right',
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `footer_link` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_favorite` tinyint(1) NOT NULL DEFAULT 0,
  `is_demo` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ext_chatbots`
--

INSERT INTO `ext_chatbots` (`id`, `uuid`, `user_id`, `interaction_type`, `title`, `bubble_message`, `welcome_message`, `connect_message`, `instructions`, `do_not_go_beyond_instructions`, `language`, `ai_model`, `ai_embedding_model`, `limit_per_minute`, `show_pre_defined_questions`, `pre_defined_questions`, `logo`, `avatar`, `trigger_avatar_size`, `trigger_background`, `trigger_foreground`, `color_mode`, `color`, `show_logo`, `show_date_and_time`, `show_average_response_time`, `position`, `active`, `footer_link`, `created_at`, `updated_at`, `is_favorite`, `is_demo`) VALUES
(1, '9f65f113-f24a-4228-9796-c419315c0b1d', 1, 'automatic_response', 'MagicBot', 'Hey there, How can I help you?', 'Hi, how can I help you?', 'I’ve forwarded your request to a human agent. An agent will connect with you as soon as possible.', 'test', 0, NULL, 'gpt-4o-search-preview', 'text-embedding-3-small', 2000, 0, NULL, NULL, 'uploads/avatars/XHRciS6wULzX6wMBwHujZZ2D4PUxFULJ8gN6X1xi.png', '60px', NULL, NULL, 'none', '#272733', 1, 1, 1, 'right', 1, NULL, '2025-03-28 14:11:19', '2025-04-07 16:20:40', 0, 0),
(2, '1f4daf1f-330e-4ede-93c4-cb6fdc3a0072', 1, 'automatic_response', 'MagicBot', 'Hey there, How can I help you?', 'Hi, how can I help you?', NULL, 'b', 0, NULL, 'gpt-4o-search-preview', 'text-embedding-3-small', 2000, 0, NULL, NULL, NULL, NULL, NULL, NULL, 'none', '#017BE5', 1, 1, 1, 'right', 1, NULL, '2025-04-03 13:30:18', '2025-04-07 16:20:40', 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `ext_chatbot_avatars`
--

CREATE TABLE `ext_chatbot_avatars` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `avatar` varchar(191) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `ext_chatbot_avatars`
--

INSERT INTO `ext_chatbot_avatars` (`id`, `user_id`, `avatar`, `created_at`) VALUES
(1, NULL, 'uploads/avatars/XHRciS6wULzX6wMBwHujZZ2D4PUxFULJ8gN6X1xi.png', '2025-01-21 20:59:58'),
(2, NULL, 'uploads/avatars/gHYCoR8SlwOj9FaP2SOgzUisYay38a9vhBCw8uEz.png', '2025-01-21 20:59:58'),
(3, NULL, 'uploads/avatars/95nveHO83T9iKsEuim0BXLq2pQfPoYS506Vc20Uh.png', '2025-01-21 20:59:58'),
(4, NULL, 'uploads/avatars/6iSvuQdohmQQVaj0TenFZ8tQQnYXrpC0m1OyHJH9.png', '2025-01-21 20:59:58'),
(5, NULL, 'uploads/avatars/zWrrxULLyB82dOgS9mFAze55R2u5Wcef77PbUssG.png', '2025-01-21 20:59:58');

-- --------------------------------------------------------

--
-- Table structure for table `ext_chatbot_channels`
--

CREATE TABLE `ext_chatbot_channels` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `chatbot_id` bigint(20) DEFAULT NULL,
  `channel` varchar(32) DEFAULT NULL,
  `credentials` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`credentials`)),
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`payload`)),
  `connected_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_chatbot_channel_webhooks`
--

CREATE TABLE `ext_chatbot_channel_webhooks` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `chatbot_id` bigint(20) DEFAULT NULL,
  `chatbot_channel_id` bigint(20) DEFAULT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`payload`)),
  `created_at` timestamp NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_chatbot_conversations`
--

CREATE TABLE `ext_chatbot_conversations` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `chatbot_channel_id` bigint(20) DEFAULT 0,
  `customer_channel_id` varchar(191) DEFAULT NULL,
  `chatbot_channel` varchar(191) DEFAULT 'frame',
  `ip_address` varchar(45) DEFAULT NULL,
  `conversation_name` varchar(191) DEFAULT 'Anonymous User',
  `chatbot_id` bigint(20) UNSIGNED NOT NULL,
  `session_id` varchar(191) NOT NULL,
  `connect_agent_at` timestamp NULL DEFAULT NULL,
  `customer_payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`customer_payload`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `last_activity_at` timestamp NULL DEFAULT NULL,
  `is_showed_on_history` tinyint(1) NOT NULL DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_chatbot_embeddings`
--

CREATE TABLE `ext_chatbot_embeddings` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `chatbot_id` bigint(20) UNSIGNED NOT NULL,
  `engine` varchar(191) NOT NULL,
  `title` varchar(191) DEFAULT NULL,
  `file` varchar(191) DEFAULT NULL,
  `url` varchar(191) DEFAULT NULL,
  `content` longtext DEFAULT NULL,
  `embedding` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`embedding`)),
  `type` varchar(191) DEFAULT 'text',
  `trained_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_chatbot_histories`
--

CREATE TABLE `ext_chatbot_histories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `chatbot_id` bigint(20) UNSIGNED NOT NULL,
  `conversation_id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `message_id` varchar(191) DEFAULT NULL,
  `model` varchar(191) DEFAULT NULL,
  `role` varchar(191) DEFAULT NULL,
  `message` text NOT NULL,
  `type` varchar(191) DEFAULT 'default',
  `message_type` varchar(191) DEFAULT 'text',
  `content_type` varchar(191) DEFAULT 'text',
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `media_url` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `ext_chatbots`
--
ALTER TABLE `ext_chatbots`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `ext_chatbots_uuid_unique` (`uuid`);

--
-- Indexes for table `ext_chatbot_avatars`
--
ALTER TABLE `ext_chatbot_avatars`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ext_chatbot_channels`
--
ALTER TABLE `ext_chatbot_channels`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ext_chatbot_channel_webhooks`
--
ALTER TABLE `ext_chatbot_channel_webhooks`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ext_chatbot_conversations`
--
ALTER TABLE `ext_chatbot_conversations`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ext_chatbot_conversations_chatbot_id_foreign` (`chatbot_id`);

--
-- Indexes for table `ext_chatbot_embeddings`
--
ALTER TABLE `ext_chatbot_embeddings`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ext_chatbot_embeddings_chatbot_id_foreign` (`chatbot_id`);

--
-- Indexes for table `ext_chatbot_histories`
--
ALTER TABLE `ext_chatbot_histories`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ext_chatbot_histories_chatbot_id_foreign` (`chatbot_id`),
  ADD KEY `ext_chatbot_histories_conversation_id_foreign` (`conversation_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `ext_chatbots`
--
ALTER TABLE `ext_chatbots`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `ext_chatbot_avatars`
--
ALTER TABLE `ext_chatbot_avatars`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=6;

--
-- AUTO_INCREMENT for table `ext_chatbot_channels`
--
ALTER TABLE `ext_chatbot_channels`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_chatbot_channel_webhooks`
--
ALTER TABLE `ext_chatbot_channel_webhooks`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_chatbot_conversations`
--
ALTER TABLE `ext_chatbot_conversations`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_chatbot_embeddings`
--
ALTER TABLE `ext_chatbot_embeddings`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_chatbot_histories`
--
ALTER TABLE `ext_chatbot_histories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `ext_chatbot_conversations`
--
ALTER TABLE `ext_chatbot_conversations`
  ADD CONSTRAINT `ext_chatbot_conversations_chatbot_id_foreign` FOREIGN KEY (`chatbot_id`) REFERENCES `ext_chatbots` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ext_chatbot_embeddings`
--
ALTER TABLE `ext_chatbot_embeddings`
  ADD CONSTRAINT `ext_chatbot_embeddings_chatbot_id_foreign` FOREIGN KEY (`chatbot_id`) REFERENCES `ext_chatbots` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ext_chatbot_histories`
--
ALTER TABLE `ext_chatbot_histories`
  ADD CONSTRAINT `ext_chatbot_histories_chatbot_id_foreign` FOREIGN KEY (`chatbot_id`) REFERENCES `ext_chatbots` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ext_chatbot_histories_conversation_id_foreign` FOREIGN KEY (`conversation_id`) REFERENCES `ext_chatbot_conversations` (`id`) ON DELETE CASCADE;
COMMIT;

-- ---------------------Ekr---Ekr----Ekr----Ekr----Ekr----Ekr----Ekr----------------
-- ---------------------Ekr---Ekr----Ekr----Ekr----Ekr----Ekr----Ekr----------------
-- ---------------------Ekr---Ekr----Ekr----Ekr----Ekr----Ekr----Ekr----------------
