-- Check if the column 'website_url' exists in the 'user_openai_chat' table
IF NOT EXISTS (
    SELECT 1
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'user_openai_chat'
    AND COLUMN_NAME = 'website_url'
)
BEGIN
    -- Add the 'website_url' column to the 'user_openai_chat' table
    ALTER TABLE user_openai_chat
    ADD website_url VARCHAR(255) NULL;
END;

-- Insert into OpenAIGenerator table
INSERT INTO openai (slug, title, description, active, questions, image, premium, type, prompt, custom_template, tone_of_voice, color, filters)
VALUES ('ai_webchat', 'AI Web Chat', 'Analyze web page content with url', 1, '[{\"name\":\"your_description\",\"type\":\"textarea\",\"question\":\"Description\",\"select\":\"\"}]', 
        '<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"48\" height=\"48\" stroke-width=\"2\" stroke=\"black\" fill=\"none\" viewBox=\"0 0 24 24\"><path stroke=\"none\" d=\"M0 0h24v24H0z\" fill=\"none\"/><path d=\"M6 4l6 16l6 -16\" /></svg>', 
        0, 'text', NULL, 0, 0, '#A3D6C2', 'blog')
ON DUPLICATE KEY UPDATE slug = 'ai_webchat';

-- Insert into OpenaiGeneratorChatCategory table
INSERT INTO openai_chat_category (slug, name, short_name, description, role, human_name, helps_with, prompt_prefix, image, color, chat_completions, plan, category)
VALUES ('ai_webchat', 'WebChat', 'WC', 'AI Web Chat', 'Web Analyzer', 'AI Web Chat', 'I can assist you with web page content analyzation', 
        'As a WebPage analyzer', 'assets/img/webchat.png', '#EDBBBE', '[{\"role\": \"system\", \"content\": \"You are a Web Page Analyzer assistant.\"}]', '', '')
ON DUPLICATE KEY UPDATE slug = 'ai_webchat';
