-- Check if the column 'plagiarism_key' exists in 'settings_two' table
IF NOT EXISTS (
    SELECT 1
    FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'settings_two'
    AND COLUMN_NAME = 'plagiarism_key'
) THEN
    -- Add 'plagiarism_key' column to 'settings_two' table
    ALTER TABLE settings_two
    ADD COLUMN plagiarism_key VARCHAR(255) NULL;
END IF;

-- Check if the 'openai' table exists
IF EXISTS (
    SELECT 1
    FROM INFORMATION_SCHEMA.TABLES
    WHERE TABLE_NAME = 'openai'
) THEN
    -- Insert or update 'ai_plagiarism' record in 'openai' table
    INSERT INTO openai (slug, title, description, active, questions, image, premium, type, prompt, custom_template, tone_of_voice, color, filters)
    VALUES ('ai_plagiarism', 'AI Plagiarism Checker', 'Analyze text, comparing it against a vast database online content to identify potential plagiarism.', 1, '[{\"name\":\"your_description\",\"type\":\"textarea\",\"question\":\"Description\",\"select\":\"\"}]', '<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"48\" viewBox=\"0 96 960 960\" width=\"48\"><path d=\"M430 896V356H200V256h560v100H530v540H430Z\"/></svg>', 0, 'text', NULL, 0, 0, '#A3D6C2', 'blog')
    ON DUPLICATE KEY UPDATE
    title = VALUES(title),
    description = VALUES(description),
    active = VALUES(active),
    questions = VALUES(questions),
    image = VALUES(image),
    premium = VALUES(premium),
    type = VALUES(type),
    prompt = VALUES(prompt),
    custom_template = VALUES(custom_template),
    tone_of_voice = VALUES(tone_of_voice),
    color = VALUES(color),
    filters = VALUES(filters);

    -- Insert or update 'ai_content_detect' record in 'openai' table
    INSERT INTO openai (slug, title, description, active, questions, image, premium, type, prompt, custom_template, tone_of_voice, color, filters)
    VALUES ('ai_content_detect', 'AI Content Detector', 'Analylze text, comparing it against a vast database online content to AI writing content.', 1, '[{\"name\":\"your_description\",\"type\":\"textarea\",\"question\":\"Description\",\"select\":\"\"}]', '<svg xmlns=\"http://www.w3.org/2000/svg\" height=\"48\" viewBox=\"0 96 960 960\" width=\"48\"><path d=\"M430 896V356H200V256h560v100H530v540H430Z\"/></svg>', 0, 'text', NULL, 0, 0, '#A3D6C2', 'blog')
    ON DUPLICATE KEY UPDATE
    title = VALUES(title),
    description = VALUES(description),
    active = VALUES(active),
    questions = VALUES(questions),
    image = VALUES(image),
    premium = VALUES(premium),
    type = VALUES(type),
    prompt = VALUES(prompt),
    custom_template = VALUES(custom_template),
    tone_of_voice = VALUES(tone_of_voice),
    color = VALUES(color),
    filters = VALUES(filters);
END IF;



-- Hacked BY Ekr
-- All Magic Ai Extensions & Themes - Hacked By Ek Entertainment - DoniaWeb ||
--

