-- Check if the table 'photo_studios' exists
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'photo_studios')
BEGIN
    -- Create the table 'photo_studios'
    CREATE TABLE photo_studios (
        id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        user_id BIGINT NULL,
        photo VARCHAR(255) NULL,
        payload TEXT NULL,
        credits INT DEFAULT 0,
        created_at TIMESTAMP NULL,
        updated_at TIMESTAMP NULL
    );
END;

-- Drop the table 'photo_studios' if it exists
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'photo_studios')
BEGIN
    DROP TABLE photo_studios;
END;
