-- The issue seems to be related to a permissions error when trying to access the `information_schema` database. 
-- This is a system database and typically, users do not have permissions to modify or access it directly.
-- To resolve this, ensure that your SQL queries are not attempting to modify or access `information_schema` directly.
-- Instead, focus on the specific databases and tables you have permissions for.
/* "extension_key": "ekr" */
/* "extension_key": "ekr" */
/* "extension_key": "ekr" */
/* "extension_key": "ekr" */

-- Here is the corrected SQL code for your specific tables:

-- Check if the entry exists before inserting to avoid duplicates
select * from `openai` where `slug` = 'ai_realtime_voice_chat' limit 1;

-- Insert the entry if it does not exist
insert into `openai` (`slug`, `title`, `description`, `active`, `questions`, `image`, `premium`, `type`, `prompt`, `custom_template`, `tone_of_voice`, `color`, `filters`, `updated_at`, `created_at`) 
values ('ai_realtime_voice_chat', 'Realtime Voice Chat', 'AI Realtime Voice Chat', 1, '[{\"name\":\"your_description\",\"type\":\"textarea\",\"question\":\"Description\",\"select\":\"\"}]', '<svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" stroke-width="2" stroke="black" fill="none" viewBox="0 0 24 24"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M6 4l6 16l6 -16" /></svg>', 0, 'text', null, 0, 0, '#A3D6C2', 'blog', now(), now());

-- Check if the entry exists before inserting to avoid duplicates
select * from `openai_chat_category` where `slug` = 'ai_realtime_voice_chat' limit 1;

-- Insert the entry if it does not exist
insert into `openai_chat_category` (`slug`, `name`, `short_name`, `description`, `role`, `human_name`, `helps_with`, `prompt_prefix`, `image`, `color`, `chat_completions`, `plan`, `category`, `updated_at`, `created_at`) 
values ('ai_realtime_voice_chat', 'Realtime Voice Chat', 'RVC', 'AI Realtime Voice Chat', 'Voice Chatting Bot', 'AI Realtime Voice Chat', 'I can assist you with voice chat', 'As a Voice Chatting', 'assets/img/chat-default.jpg', '#EDBBBE', '[{"role": "system", "content": "You are a Voice Chatting assistant."}]', '', '', now(), now());

/* "extension_key": "ekr" */
/* "extension_key": "ekr" */
/* "extension_key": "ekr" */
/* "extension_key": "ekr" */
/* "extension_key": "ekr" */
