

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


--
-- HaCkeD By Ekr DoniaWeb
-- nulled by Ekr DoniaWeb

-- ------------------------- Ekr DoniaWeb -------------------------------

--
-- HaCkeD By Ekr DoniaWeb
-- nulled by Ekr DoniaWeb

-- ------------------------- Ekr DoniaWeb -------------------------------

--
-- Table structure for table `ext_contacts`
--

CREATE TABLE `ext_contacts` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_contact_lists`
--

CREATE TABLE `ext_contact_lists` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `country_code` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `phone` varchar(191) NOT NULL,
  `avatar` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_contact_list_contact`
--

CREATE TABLE `ext_contact_list_contact` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `contact_list_id` bigint(20) UNSIGNED NOT NULL,
  `contact_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_contact_list_segment`
--

CREATE TABLE `ext_contact_list_segment` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `contact_list_id` bigint(20) UNSIGNED NOT NULL,
  `segment_id` bigint(20) UNSIGNED NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_marketing_campaigns`
--

CREATE TABLE `ext_marketing_campaigns` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `template_id` bigint(20) DEFAULT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `content` text DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `contacts` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`contacts`)),
  `segments` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`segments`)),
  `type` varchar(191) DEFAULT NULL,
  `status` varchar(191) NOT NULL DEFAULT 'pending',
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `started_at` timestamp NULL DEFAULT NULL,
  `finished_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_marketing_conversations`
--

CREATE TABLE `ext_marketing_conversations` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `type` varchar(191) DEFAULT NULL,
  `telegram_group_id` varchar(191) DEFAULT NULL,
  `whatsapp_channel_id` varchar(191) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `conversation_name` varchar(191) DEFAULT NULL,
  `connect_agent_at` timestamp NULL DEFAULT NULL,
  `session_id` varchar(191) DEFAULT NULL,
  `customer_payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`customer_payload`)),
  `is_showed_on_history` tinyint(1) NOT NULL DEFAULT 0,
  `last_activity_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_marketing_message_histories`
--

CREATE TABLE `ext_marketing_message_histories` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `conversation_id` bigint(20) UNSIGNED NOT NULL,
  `message_id` varchar(191) NOT NULL,
  `model` varchar(191) DEFAULT NULL,
  `role` varchar(191) NOT NULL,
  `message` text NOT NULL,
  `type` varchar(191) DEFAULT NULL,
  `media_url` varchar(191) DEFAULT NULL,
  `message_type` varchar(191) DEFAULT NULL,
  `content_type` varchar(191) DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_segments`
--

CREATE TABLE `ext_segments` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_telegram_contacts`
--

CREATE TABLE `ext_telegram_contacts` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `telegram_id` varchar(191) DEFAULT NULL,
  `contact_id` varchar(191) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `username` varchar(191) DEFAULT NULL,
  `group_chat_id` varchar(191) DEFAULT NULL,
  `group_id` bigint(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_telegram_groups`
--

CREATE TABLE `ext_telegram_groups` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `group_id` varchar(191) DEFAULT NULL,
  `bot_id` int(11) DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT 'telegram',
  `group_type` varchar(191) DEFAULT NULL,
  `supergroup_subscriber_id` varchar(191) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `ext_telegram_group_subscribers`
--

CREATE TABLE `ext_telegram_group_subscribers` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `username` varchar(191) DEFAULT NULL,
  `avatar` varchar(191) DEFAULT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `client_id` varchar(191) DEFAULT NULL,
  `group_chat_id` varchar(191) DEFAULT NULL,
  `group_subscriber_id` varchar(191) DEFAULT NULL,
  `group_id` varchar(191) DEFAULT NULL,
  `unique_id` varchar(191) DEFAULT NULL,
  `is_left_group` tinyint(1) NOT NULL DEFAULT 0,
  `type` varchar(191) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `is_blacklist` tinyint(1) NOT NULL DEFAULT 0,
  `is_bot` tinyint(1) NOT NULL DEFAULT 0,
  `is_admin` tinyint(1) NOT NULL DEFAULT 0,
  `scopes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`scopes`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------
-- SQL Migration: Create ext_telegram_bots Table

CREATE TABLE IF NOT EXISTS `ext_telegram_bots` (
    `id` BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
    `user_id` BIGINT NULL,
    `access_token` VARCHAR(255) NULL,
    `is_connected` BOOLEAN NOT NULL DEFAULT FALSE,
    `webhook_verified` BOOLEAN NOT NULL DEFAULT FALSE,
    `bot_id` BIGINT NULL,
    `name` VARCHAR(255) NULL,
    `username` VARCHAR(255) NULL,
    `scopes` JSON NULL,
    `created_at` TIMESTAMP NULL DEFAULT NULL,
    `updated_at` TIMESTAMP NULL DEFAULT NULL
);

-- To drop the table (reverse migration)
-- DROP TABLE IF EXISTS `ext_telegram_bots`;

--
-- Table structure for table `ext_whatsapp_channels`
--

CREATE TABLE `ext_whatsapp_channels` (
  `id` bigint(20) UNSIGNED NOT NULL,
  `user_id` bigint(20) UNSIGNED DEFAULT NULL,
  `whatsapp_sid` varchar(191) DEFAULT NULL,
  `whatsapp_token` varchar(191) DEFAULT NULL,
  `whatsapp_phone` varchar(191) DEFAULT NULL,
  `whatsapp_sandbox_phone` varchar(191) DEFAULT NULL,
  `whatsapp_environment` varchar(191) NOT NULL DEFAULT 'sandbox',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `ext_contacts`
--
ALTER TABLE `ext_contacts`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ext_contact_lists`
--
ALTER TABLE `ext_contact_lists`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ext_contact_list_contact`
--
ALTER TABLE `ext_contact_list_contact`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ext_contact_list_contact_contact_list_id_foreign` (`contact_list_id`),
  ADD KEY `ext_contact_list_contact_contact_id_foreign` (`contact_id`);

--
-- Indexes for table `ext_contact_list_segment`
--
ALTER TABLE `ext_contact_list_segment`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ext_contact_list_segment_contact_list_id_foreign` (`contact_list_id`),
  ADD KEY `ext_contact_list_segment_segment_id_foreign` (`segment_id`);

--
-- Indexes for table `ext_marketing_campaigns`
--
ALTER TABLE `ext_marketing_campaigns`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ext_marketing_conversations`
--
ALTER TABLE `ext_marketing_conversations`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ext_marketing_message_histories`
--
ALTER TABLE `ext_marketing_message_histories`
  ADD PRIMARY KEY (`id`),
  ADD KEY `ext_marketing_message_histories_conversation_id_index` (`conversation_id`),
  ADD KEY `ext_marketing_message_histories_message_id_index` (`message_id`),
  ADD KEY `ext_marketing_message_histories_role_index` (`role`);

--
-- Indexes for table `ext_segments`
--
ALTER TABLE `ext_segments`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ext_telegram_contacts`
--
ALTER TABLE `ext_telegram_contacts`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ext_telegram_groups`
--
ALTER TABLE `ext_telegram_groups`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ext_telegram_group_subscribers`
--
ALTER TABLE `ext_telegram_group_subscribers`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `ext_whatsapp_channels`
--
ALTER TABLE `ext_whatsapp_channels`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `ext_contacts`
--
ALTER TABLE `ext_contacts`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_contact_lists`
--
ALTER TABLE `ext_contact_lists`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_contact_list_contact`
--
ALTER TABLE `ext_contact_list_contact`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_contact_list_segment`
--
ALTER TABLE `ext_contact_list_segment`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_marketing_campaigns`
--
ALTER TABLE `ext_marketing_campaigns`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_marketing_conversations`
--
ALTER TABLE `ext_marketing_conversations`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_marketing_message_histories`
--
ALTER TABLE `ext_marketing_message_histories`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_segments`
--
ALTER TABLE `ext_segments`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_telegram_contacts`
--
ALTER TABLE `ext_telegram_contacts`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_telegram_groups`
--
ALTER TABLE `ext_telegram_groups`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_telegram_group_subscribers`
--
ALTER TABLE `ext_telegram_group_subscribers`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `ext_whatsapp_channels`
--
ALTER TABLE `ext_whatsapp_channels`
  MODIFY `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `ext_contact_list_contact`
--
ALTER TABLE `ext_contact_list_contact`
  ADD CONSTRAINT `ext_contact_list_contact_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `ext_contacts` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ext_contact_list_contact_contact_list_id_foreign` FOREIGN KEY (`contact_list_id`) REFERENCES `ext_contact_lists` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `ext_contact_list_segment`
--
ALTER TABLE `ext_contact_list_segment`
  ADD CONSTRAINT `ext_contact_list_segment_contact_list_id_foreign` FOREIGN KEY (`contact_list_id`) REFERENCES `ext_contact_lists` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `ext_contact_list_segment_segment_id_foreign` FOREIGN KEY (`segment_id`) REFERENCES `ext_segments` (`id`) ON DELETE CASCADE;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
