-- ExtensionKey=BYEKRRR74747
SHOW TABLE STATUS;
drop table if exists `automation_campaigns`;
create table `automation_campaigns` (
  `id` bigint unsigned not null auto_increment primary key,
  `user_id` int not null,
  `name` varchar(191) null,
  `target_audience` text null,
  `created_at` timestamp null,
  `updated_at` timestamp null
) default character set utf8mb4 collate 'utf8mb4_unicode_ci' engine = InnoDB;

SHOW TABLE STATUS;
drop table if exists `automations`;
create table `automations` (
  `id` bigint unsigned not null auto_increment primary key,
  `custom` longtext null,
  `value` longtext null,
  `created_at` timestamp null,
  `updated_at` timestamp null
) default character set utf8mb4 collate 'utf8mb4_unicode_ci' engine = InnoDB;

SHOW TABLE STATUS;
drop table if exists `linkedin_tokens`;
create table `linkedin_tokens` (
  `id` bigint unsigned not null auto_increment primary key,
  `user_id` bigint null,
  `access_token` text null,
  `created_at` timestamp null,
  `updated_at` timestamp null
) default character set utf8mb4 collate 'utf8mb4_unicode_ci' engine = InnoDB;

SHOW TABLE STATUS;
drop table if exists `scheduled_posts`;
create table `scheduled_posts` (
  `id` bigint unsigned not null auto_increment primary key,
  `user_id` bigint null,
  `company_id` bigint null,
  `platform` varchar(191) null,
  `products` text null,
  `campaign_name` varchar(191) null,
  `campaign_target` longtext null,
  `topics` longtext null,
  `is_seo` tinyint(1) not null default '0',
  `tone` varchar(191) null,
  `length` varchar(191) null,
  `is_email` tinyint(1) not null default '0',
  `is_repeated` tinyint(1) not null default '0',
  `repeat_period` varchar(191) null,
  `repeat_start_date` date null,
  `repeat_time` time null,
  `visual_format` varchar(191) null,
  `visual_ratio` varchar(191) null,
  `posted_at` varchar(191) null,
  `prompt` longtext null,
  `created_at` timestamp null,
  `updated_at` timestamp null
) default character set utf8mb4 collate 'utf8mb4_unicode_ci' engine = InnoDB;

SHOW TABLE STATUS;
drop table if exists `twitter_settings`;
create table `twitter_settings` (
  `id` bigint unsigned not null auto_increment primary key,
  `user_id` bigint unsigned null,
  `consumer_key` text null,
  `consumer_secret` text null,
  `access_token` text null,
  `access_token_secret` text null,
  `bearer_token` text null,
  `account_id` text null,
  `created_at` timestamp null,
  `updated_at` timestamp null
) default character set utf8mb4 collate 'utf8mb4_unicode_ci' engine = InnoDB;

SHOW FULL COLUMNS FROM `scheduled_posts`;

alter table `scheduled_posts` add `command_running` tinyint(1) not null default '0' after `id`, add `last_run_date` date null after `command_running`;

SHOW INDEX FROM `scheduled_posts`;

alter table `scheduled_posts` add index `command_running_last_run_date_index`(`command_running`, `last_run_date`, `repeat_period`, `repeat_time`);

drop table if exists `automation_platforms`;
create table `automation_platforms` (
  `id` bigint unsigned not null auto_increment primary key,
  `user_id` bigint unsigned null,
  `platform` varchar(191) null,
  `credentials` json null,
  `connected_at` timestamp null,
  `expires_at` timestamp null,
  `created_at` timestamp null,
  `updated_at` timestamp null
) default character set utf8mb4 collate 'utf8mb4_unicode_ci' engine = InnoDB;

select * from `twitter_settings`;
select * from `linkedin_tokens`;

alter table `scheduled_posts` add `automation_platform_id` bigint null after `id`;

-- Print "Done ByEKR"
select 'Done ByEKR';
