@php
    $filters = ['User', 'Admin'];
@endphp

@extends('panel.layout.settings')
@section('title', __($megaMenu->name) . ' items')
@section('titlebar_actions')
    <x-modal
        title="{{ __('New menu item') }}"
        disable-modal="{{ $app_is_demo }}"
        disable-modal-message="{{ __('This feature is disabled in Demo version.') }}"
    >
        <x-slot:trigger>
            <x-tabler-plus class="size-4" />
            {{ __('Add Menu Item') }}
        </x-slot:trigger>
        <x-slot:modal>
            <form
                class="menu-item-add-form flex flex-col gap-6"
                method="post"
                action="#"
                x-data="{ selectedType: 'label' }"
            >
                @csrf
                <x-forms.input
                    id="type"
                    type="select"
                    size="lg"
                    name="type"
                    label="{{ __('Type') }}"
                    x-model="selectedType"
                >
                    <option value="label">@lang('Title')</option>
                    <option value="divider">@lang('Divider')</option>
                    <option value="v-space">@lang('Empty Space')</option>
                    <option value="item">@lang('Link')</option>
                </x-forms.input>

                <div :class="{ hidden: selectedType !== 'v-space' }">
                    <x-forms.input
                        id="space"
                        name="space"
                        label="{{ __('Space Value') }}"
                        placeholder="{{ __('Enter space value in px') }}"
                        ::type="selectedType !== 'v-space' ? 'hidden' : 'text'"
                        size="lg"
                        type="number"
                        stepper
                    />
                </div>

                <div :class="{ hidden: selectedType === 'divider' || selectedType === 'v-space' }">
                    <x-forms.input
                        id="label"
                        name="label"
                        label="{{ __('Label') }}"
                        placeholder="{{ __('Enter text') }}"
                        ::type="selectedType === 'divider' ? 'hidden' : 'text'"
                        size="lg"
                    />
                </div>
                <div :class="{ hidden: (selectedType === 'divider' || selectedType === 'v-space' || selectedType === 'label') }">
                    <x-forms.input
                        id="link"
                        name="link"
                        label="{{ __('Link') }}"
                        value="https://"
                        placeholder="{{ __('https://www.example.com') }}"
                        ::type="(selectedType === 'divider' || selectedType === 'v-space' || selectedType === 'label') ? 'hidden' : 'text'"
                        size="lg"
                    />
                </div>
                <div :class="{ hidden: (selectedType === 'divider' || selectedType === 'v-space') }">
                    <x-forms.input
                        id="description"
                        name="description"
                        label="{{ __('Description') }}"
                        value=""
                        placeholder="{{ __('Menu description') }}"
                        ::type="(selectedType === 'divider' || selectedType === 'v-space') ? 'hidden' : 'text'"
                        size="lg"
                    />
                </div>

                <div class="flex justify-end gap-2">
                    <x-button
                        @click.prevent="modalOpen = false"
                        variant="ghost-shadow"
                        type="button"
                    >
                        {{ __('Cancel') }}
                    </x-button>
                    <x-button type="submit">
                        {{ __('Add Item') }}
                    </x-button>
                </div>
            </form>
        </x-slot:modal>
    </x-modal>
@endsection

@push('css')
    <style>
        .lqd-menu-management {
            --switcher-ball: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='-4 -4 8 8'%3e%3ccircle r='3' fill='%23ffffff'/%3e%3c/svg%3e");
        }

        .lqd-menu-list ol {
            display: flex;
            flex-direction: column;
            margin-top: 1rem;
            gap: 1rem;
            padding-inline-start: 4rem;
        }

        .lqd-menu-item-placeholder {
            border: 2px dashed hsl(var(--heading-foreground) / 25%);
            border-radius: 0.75rem;
        }
    </style>
@endpush

@section('settings')
    <div class="lqd-menu-management">
        <h2 class="mb-5">
            <span class="opacity-60">
                @lang('Editing:')
            </span>
            {{ $megaMenu->name }}
        </h2>
        {{--        <p class="mb-5"> --}}
        {{--            @lang('With the MagicAI menu creator, you can edit menu labels, upload custom images and change the number of columns.') --}}
        {{--        </p> --}}

        {{--        <div class="mb-5 flex w-full gap-6"> --}}
        {{--            <div class="w-full"> --}}
        {{--                <x-forms.input --}}
        {{--                    id="number_of_columns" --}}
        {{--                    tooltip="{{ __('The name of the menu') }}" --}}
        {{--                    name="number_of_columns" --}}
        {{--                    label="{{ __('Number of Columns') }}" --}}
        {{--                    value="{{ $megaMenu->number_of_columns }}" --}}
        {{--                    size="lg" --}}
        {{--                    type="number" --}}
        {{--                    stepper="true" --}}
        {{--                /> --}}
        {{--            </div> --}}

        {{--        </div> --}}

        <x-form-step
            class="mb-5"
            step="1"
            label="{{ __('Frontend') }}"
        />
        <div class="lqd-user-menu-list">
            <ol class="lqd-menu-list flex flex-col gap-4">
                @foreach ($items as $item)
                    <li
                        class="group/item text-xs font-medium"
                        id="{{ 'menu-' . $item['id'] }}"
                        @if ($item['type']) data-type="{{ $item['type'] }}" @endif
                    >
                        <div class="items-center gap-5 rounded-xl border bg-background px-4 py-3 transition-all hover:shadow-lg hover:shadow-black/5">
                            <div class="flex w-full items-center gap-5">
                                <div class="lqd-menu-item-handle flex size-6 cursor-grab items-center justify-center">
                                    <svg
                                        width="10"
                                        height="16"
                                        viewBox="0 0 10 16"
                                        fill="none"
                                        xmlns="http://www.w3.org/2000/svg"
                                    >
                                        <path
                                            d="M2 16C1.45 16 0.979167 15.8042 0.5875 15.4125C0.195833 15.0208 0 14.55 0 14C0 13.45 0.195833 12.9792 0.5875 12.5875C0.979167 12.1958 1.45 12 2 12C2.55 12 3.02083 12.1958 3.4125 12.5875C3.80417 12.9792 4 13.45 4 14C4 14.55 3.80417 15.0208 3.4125 15.4125C3.02083 15.8042 2.55 16 2 16ZM8 16C7.45 16 6.97917 15.8042 6.5875 15.4125C6.19583 15.0208 6 14.55 6 14C6 13.45 6.19583 12.9792 6.5875 12.5875C6.97917 12.1958 7.45 12 8 12C8.55 12 9.02083 12.1958 9.4125 12.5875C9.80417 12.9792 10 13.45 10 14C10 14.55 9.80417 15.0208 9.4125 15.4125C9.02083 15.8042 8.55 16 8 16ZM2 10C1.45 10 0.979167 9.80417 0.5875 9.4125C0.195833 9.02083 0 8.55 0 8C0 7.45 0.195833 6.97917 0.5875 6.5875C0.979167 6.19583 1.45 6 2 6C2.55 6 3.02083 6.19583 3.4125 6.5875C3.80417 6.97917 4 7.45 4 8C4 8.55 3.80417 9.02083 3.4125 9.4125C3.02083 9.80417 2.55 10 2 10ZM8 10C7.45 10 6.97917 9.80417 6.5875 9.4125C6.19583 9.02083 6 8.55 6 8C6 7.45 6.19583 6.97917 6.5875 6.5875C6.97917 6.19583 7.45 6 8 6C8.55 6 9.02083 6.19583 9.4125 6.5875C9.80417 6.97917 10 7.45 10 8C10 8.55 9.80417 9.02083 9.4125 9.4125C9.02083 9.80417 8.55 10 8 10ZM2 4C1.45 4 0.979167 3.80417 0.5875 3.4125C0.195833 3.02083 0 2.55 0 2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0C2.55 0 3.02083 0.195833 3.4125 0.5875C3.80417 0.979167 4 1.45 4 2C4 2.55 3.80417 3.02083 3.4125 3.4125C3.02083 3.80417 2.55 4 2 4ZM8 4C7.45 4 6.97917 3.80417 6.5875 3.4125C6.19583 3.02083 6 2.55 6 2C6 1.45 6.19583 0.979167 6.5875 0.5875C6.97917 0.195833 7.45 0 8 0C8.55 0 9.02083 0.195833 9.4125 0.5875C9.80417 0.979167 10 1.45 10 2C10 2.55 9.80417 3.02083 9.4125 3.4125C9.02083 3.80417 8.55 4 8 4Z"
                                            fill="#A6A5AB"
                                        />
                                    </svg>
                                </div>

                                <div class="flex w-full grow items-center gap-3">
                                    @if ($item['type'] === 'divider' || $item['type'] === 'v-space')
                                        @if ($item['type'] === 'divider')
                                            <hr class="m-0 h-[1lh] w-px border-s-2 border-heading-foreground/15">
                                        @endif
                                        <span class="cursor-default">
                                            @lang($item['type'] === 'divider' ? 'Divider' : 'Empty Space')
                                        </span>
                                        @if ($item['type'] === 'v-space')
                                            <span
                                                class="inline-block h-4 grow opacity-15"
                                                style="background: repeating-linear-gradient( -45deg, transparent 0 2px, hsl(var(--heading-foreground)) 2px 4px )"
                                            ></span>
                                        @endif
                                    @else
                                        @if ($item['type'] === 'label')
                                            <span
                                                class="lqd-menu-item-c inline-flex size-6 shrink-0 items-center justify-center rounded-md bg-primary text-4xs uppercase text-primary-foreground"
                                            >
                                                {{ substr($item['label'], 0, 1) }}
                                            </span>
                                        @endif
                                        @if ($item['type'] === 'item')
                                            <button class="icon-wrap cursor-pointer transition-transform [&_i]:size-6 [&_i]:text-[24px]">
                                                <div class="relative flex justify-center">
                                                    <input
                                                        class="peer invisible size-0"
                                                        id="avatar-custom-{{ $item['id'] }}"
                                                        data-div="{{ 'icon-wrap-' . $item['id'] }}"
                                                        data-link="{{ route('dashboard.admin.mega-menu.items.upload', [$megaMenu['id'], $item['id']]) }}"
                                                        type="file"
                                                    >
                                                    <label
                                                        id="{{ 'icon-wrap-' . $item['id'] }}"
                                                        @class([
                                                            'inline-grid hover:scale-110 size-10 cursor-pointer place-items-center rounded-full bg-heading-foreground/5 text-heading-foreground transition-all peer-checked:drop-shadow-xl',
                                                            'hover:bg-heading-foreground hover:text-heading-background' => !$item[
                                                                'icon'
                                                            ],
                                                        ])
                                                        for="avatar-custom-{{ $item['id'] }}"
                                                        tabindex="0"
                                                    >
                                                        @if ($item['icon'])
                                                            <img
                                                                class="mx-auto max-w-8"
                                                                src="{{ $item->icon_url }}"
                                                                alt="Image"
                                                            >
                                                        @else
                                                            <x-tabler-plus class="size-4" />
                                                        @endif
                                                    </label>
                                                </div>
                                            </button>
                                        @endif
                                        <div class="flex flex-col">
                                            <input
                                                class="w-full text-ellipsis border-none bg-transparent text-lg font-bold"
                                                data-link="{{ route('dashboard.admin.mega-menu.items.update', [$megaMenu->id, $item['id'], 'label']) }}"
                                                data-item="input"
                                                type="text"
                                                name="label"
                                                value="{{ $item['label'] }}"
                                            >
                                            <input
                                                class="w-full text-ellipsis border-none bg-transparent text-xs"
                                                data-link="{{ route('dashboard.admin.mega-menu.items.update', [$megaMenu->id, $item['id'], 'description']) }}"
                                                data-item="input"
                                                type="text"
                                                name="description"
                                                value="{{ $item['description'] }}"
                                            >
                                        </div>
                                    @endif

                                </div>
                                <div class="ms-auto flex items-center gap-2">
                                    <x-button
                                        class="size-6"
                                        data-item="delete"
                                        variant="ghost"
                                        hover-variant="danger"
                                        size="none"
                                        href="{{ route('dashboard.admin.mega-menu.items.delete', [$megaMenu->id, $item['id']]) }}"
                                        onclick="return confirm('{{ __('Are you sure? This is permanent.') }}')"
                                    >
                                        <x-tabler-trash class="size-5" />
                                    </x-button>
                                    <x-forms.input
                                        class="h-4 w-8 bg-input-border [background-size:10px]"
                                        id="login_without_confirmation"
                                        data-href="{{ route('dashboard.admin.mega-menu.items.status', [$megaMenu['id'], $item['id']]) }}"
                                        data-status="menu"
                                        type="checkbox"
                                        switcher
                                        type="checkbox"
                                        :checked="$item['is_active'] == '1'"
                                    />
                                </div>
                            </div>
                        </div>
                        @php
                            $children = $item['children'];
                        @endphp

                        @if ($children)
                            <ol class="lqd-menu-list-children mt-4 flex flex-col gap-4 ps-16">
                                @foreach ($children as $child)
                                    <li
                                        class="group/child"
                                        id="{{ 'menu-' . $child['id'] }}"
                                        @if (isset($child['type']) && $child['type']) data-type="{{ $child['type'] }}" @endif
                                    >
                                        <div class="flex w-full items-center gap-5 rounded-xl border bg-background px-4 py-3 transition-all hover:shadow-lg hover:shadow-black/5">
                                            <div class="lqd-menu-item-handle flex size-6 cursor-grab items-center justify-center">
                                                <svg
                                                    width="10"
                                                    height="16"
                                                    viewBox="0 0 10 16"
                                                    fill="none"
                                                    xmlns="http://www.w3.org/2000/svg"
                                                >
                                                    <path
                                                        d="M2 16C1.45 16 0.979167 15.8042 0.5875 15.4125C0.195833 15.0208 0 14.55 0 14C0 13.45 0.195833 12.9792 0.5875 12.5875C0.979167 12.1958 1.45 12 2 12C2.55 12 3.02083 12.1958 3.4125 12.5875C3.80417 12.9792 4 13.45 4 14C4 14.55 3.80417 15.0208 3.4125 15.4125C3.02083 15.8042 2.55 16 2 16ZM8 16C7.45 16 6.97917 15.8042 6.5875 15.4125C6.19583 15.0208 6 14.55 6 14C6 13.45 6.19583 12.9792 6.5875 12.5875C6.97917 12.1958 7.45 12 8 12C8.55 12 9.02083 12.1958 9.4125 12.5875C9.80417 12.9792 10 13.45 10 14C10 14.55 9.80417 15.0208 9.4125 15.4125C9.02083 15.8042 8.55 16 8 16ZM2 10C1.45 10 0.979167 9.80417 0.5875 9.4125C0.195833 9.02083 0 8.55 0 8C0 7.45 0.195833 6.97917 0.5875 6.5875C0.979167 6.19583 1.45 6 2 6C2.55 6 3.02083 6.19583 3.4125 6.5875C3.80417 6.97917 4 7.45 4 8C4 8.55 3.80417 9.02083 3.4125 9.4125C3.02083 9.80417 2.55 10 2 10ZM8 10C7.45 10 6.97917 9.80417 6.5875 9.4125C6.19583 9.02083 6 8.55 6 8C6 7.45 6.19583 6.97917 6.5875 6.5875C6.97917 6.19583 7.45 6 8 6C8.55 6 9.02083 6.19583 9.4125 6.5875C9.80417 6.97917 10 7.45 10 8C10 8.55 9.80417 9.02083 9.4125 9.4125C9.02083 9.80417 8.55 10 8 10ZM2 4C1.45 4 0.979167 3.80417 0.5875 3.4125C0.195833 3.02083 0 2.55 0 2C0 1.45 0.195833 0.979167 0.5875 0.5875C0.979167 0.195833 1.45 0 2 0C2.55 0 3.02083 0.195833 3.4125 0.5875C3.80417 0.979167 4 1.45 4 2C4 2.55 3.80417 3.02083 3.4125 3.4125C3.02083 3.80417 2.55 4 2 4ZM8 4C7.45 4 6.97917 3.80417 6.5875 3.4125C6.19583 3.02083 6 2.55 6 2C6 1.45 6.19583 0.979167 6.5875 0.5875C6.97917 0.195833 7.45 0 8 0C8.55 0 9.02083 0.195833 9.4125 0.5875C9.80417 0.979167 10 1.45 10 2C10 2.55 9.80417 3.02083 9.4125 3.4125C9.02083 3.80417 8.55 4 8 4Z"
                                                        fill="#A6A5AB"
                                                    />
                                                </svg>
                                            </div>
                                            <div class="flex w-full grow items-center gap-3">
                                                @if ($child['type'] === 'divider' || $child['type'] === 'v-space')
                                                    <span class="cursor-default">
                                                        @lang($child['type'] === 'divider' ? 'Divider' : 'Empty Space')
                                                    </span>
                                                    @if ($child['type'] === 'divider')
                                                        <hr class="grow border-t-2 border-heading-foreground/15">
                                                    @else
                                                        <span
                                                            class="inline-block h-4 grow opacity-15"
                                                            style="background: repeating-linear-gradient( -45deg, transparent 0 2px, hsl(var(--heading-foreground)) 2px 4px )"
                                                        ></span>
                                                    @endif
                                                @else
                                                    @if ($child['type'] === 'label')
                                                        <span
                                                            class="lqd-menu-item-c inline-flex size-6 shrink-0 items-center justify-center rounded-md bg-primary text-4xs uppercase text-primary-foreground"
                                                        >
                                                            {{ substr($child['label'], 0, 1) }}
                                                        </span>
                                                    @endif
                                                    @if ($child['type'] === 'item')
                                                        <button class="icon-wrap cursor-pointer transition-transform [&_i]:size-6 [&_i]:text-[24px]">
                                                            <div class="relative flex justify-center">
                                                                <input
                                                                    class="peer invisible size-0"
                                                                    id="avatar-custom-{{ $child['id'] }}"
                                                                    data-div="{{ 'icon-wrap-' . $child['id'] }}"
                                                                    data-link="{{ route('dashboard.admin.mega-menu.items.upload', [$megaMenu['id'], $child['id']]) }}"
                                                                    type="file"
                                                                >
                                                                <label
                                                                    id="{{ 'icon-wrap-' . $child['id'] }}"
                                                                    @class([
                                                                        'inline-grid hover:scale-110 size-10 cursor-pointer place-items-center rounded-full bg-heading-foreground/5 text-heading-foreground transition-all peer-checked:drop-shadow-xl',
                                                                        'hover:bg-heading-foreground hover:text-heading-background' => !$child[
                                                                            'icon'
                                                                        ],
                                                                    ])
                                                                    for="avatar-custom-{{ $child['id'] }}"
                                                                    tabindex="0"
                                                                >
                                                                    @if ($child['icon'])
                                                                        <img
                                                                            class="mx-auto max-w-8"
                                                                            src="{{ $child->icon_url }}"
                                                                            alt="Image"
                                                                        >
                                                                    @else
                                                                        <x-tabler-plus class="size-4" />
                                                                    @endif
                                                                </label>
                                                            </div>
                                                        </button>
                                                    @endif

                                                    <div class="flex flex-col">
                                                        <input
                                                            class="w-full text-ellipsis border-none bg-transparent text-lg font-bold"
                                                            data-link="{{ route('dashboard.admin.mega-menu.items.update', [$megaMenu->id, $child['id'], 'label']) }}"
                                                            data-item="input"
                                                            type="text"
                                                            name="label"
                                                            value="{{ $child['label'] }}"
                                                        >
                                                        <input
                                                            class="w-full text-ellipsis border-none bg-transparent text-xs"
                                                            data-link="{{ route('dashboard.admin.mega-menu.items.update', [$megaMenu->id, $child['id'], 'description']) }}"
                                                            data-item="input"
                                                            type="text"
                                                            name="description"
                                                            value="{{ $child['description'] }}"
                                                        >
                                                    </div>
                                                @endif
                                            </div>

                                            <div class="ms-auto flex items-center gap-2">
                                                <x-button
                                                    class="size-6"
                                                    data-item="delete"
                                                    variant="ghost"
                                                    hover-variant="danger"
                                                    size="none"
                                                    href="{{ route('dashboard.admin.mega-menu.items.delete', [$megaMenu->id, $child['id']]) }}"
                                                    onclick="return confirm('{{ __('Are you sure? This is permanent.') }}')"
                                                >
                                                    <x-tabler-trash class="size-5" />
                                                </x-button>
                                                <x-forms.input
                                                    class="h-4 w-8 bg-input-border [background-size:10px]"
                                                    id="login_without_confirmation"
                                                    data-href="{{ route('dashboard.admin.mega-menu.items.status', [$megaMenu['id'], $item['id']]) }}"
                                                    data-status="menu"
                                                    type="checkbox"
                                                    switcher
                                                    type="checkbox"
                                                    :checked="$child['is_active'] == '1'"
                                                />
                                            </div>
                                        </div>
                                    </li>
                                @endforeach
                            </ol>
                        @endif
                    </li>
                @endforeach
            </ol>
        </div>
    </div>
@endsection
@push('script')
    @include('mega-menu::partials.script')
@endpush
