<?php

namespace App\Extensions\CreativeSuite\System\Helpers;

use App\Helpers\Classes\Helper;

class Tool
{
    public static function get(): array
    {
        $tools = [
            [
                'show'        => (bool) setting('novita_api_key'),
                'action'      => 'merge_face',
                'model'       => setting('merge_face_model', 'novita') ?? 'novita',
                'image'       => 'assets/img/advanced-image/enhance/merge-face.png',
                'title'       => 'Merge Face',
                'description' => 'Replace faces in source images with the target image.',
                'premium'     => false,
                'icon'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" width="24" height="24" stroke-width="2"> <path d="M13.192 9h6.616a2 2 0 0 1 1.992 2.183l-.567 6.182a4 4 0 0 1 -3.983 3.635h-1.5a4 4 0 0 1 -3.983 -3.635l-.567 -6.182a2 2 0 0 1 1.992 -2.183z"></path> <path d="M15 13h.01"></path> <path d="M18 13h.01"></path> <path d="M15 16.5c1 .667 2 .667 3 0"></path> <path d="M8.632 15.982a4.037 4.037 0 0 1 -.382 .018h-1.5a4 4 0 0 1 -3.983 -3.635l-.567 -6.182a2 2 0 0 1 1.992 -2.183h6.616a2 2 0 0 1 2 2"></path> <path d="M6 8h.01"></path> <path d="M9 8h.01"></path> <path d="M6 12c.764 -.51 1.528 -.63 2.291 -.36"></path> </svg> ',
                'models'      => [
                    'novita',

                ],
            ],
            [
                'show'        => (bool) setting('clipdrop_api_key'),
                'action'      => 'uncrop',
                'model'       => setting('uncrop_model', 'clipdrop') ?? 'clipdrop',
                'image'       => 'assets/img/advanced-image/enhance/generative-fill.jpg',
                'title'       => 'Generative Fill',
                'description' => 'Fill in missing or damaged parts of images with smart restoration.',
                'premium'     => false,
                'icon'        => '<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="currentColor"> <path d="M16.8772 16.8774L21.2143 21.2146M10.2143 19.6428C15.4216 19.6428 19.6429 15.4215 19.6429 10.2143C19.6429 5.00702 15.4216 0.785706 10.2143 0.785706C5.00708 0.785706 0.785767 5.00702 0.785767 10.2143C0.785767 15.4215 5.00708 19.6428 10.2143 19.6428ZM5.42079 10.7299C4.8428 10.6293 4.8428 9.79961 5.42079 9.69905C7.51473 9.33476 9.18017 7.73986 9.63465 5.66364L9.66949 5.50449C9.79455 4.93326 10.6079 4.9297 10.7379 5.49982L10.7802 5.68529C11.2516 7.75171 12.9174 9.33315 15.0056 9.69643C15.5865 9.79749 15.5865 10.6314 15.0056 10.7325C12.9174 11.0958 11.2516 12.6772 10.7802 14.7437L10.7379 14.9291C10.6079 15.4992 9.79455 15.4957 9.66949 14.9244L9.63465 14.7653C9.18017 12.6891 7.51473 11.0942 5.42079 10.7299Z" stroke-width="1.25" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                'models'      => [
                    'clipdrop',
                ],
            ],
            [
                'show'        => (bool) setting('freepik_api_key'),
                'model'       => setting('reimagine_model', 'freepik') ?? 'freepik',
                'action'      => 'reimagine',
                'image'       => 'assets/img/advanced-image/enhance/reimagine.jpg',
                'title'       => 'Reimagine (Beta)',
                'description' => 'Transform your existing images with creative, AI-driven edits.',
                'premium'     => false,
                'icon'        => '<svg width="23" height="17" viewBox="0 0 23 17" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M13.9477 11.8893H15.3019V9.17709H18.0141V7.82293H15.3019V5.11069H13.9477V7.82293H11.2355V9.17709H13.9477V11.8893ZM5.2498 16.0901C3.69129 15.4651 2.45101 14.4649 1.52896 13.0896C0.606741 11.7142 0.14563 10.1844 0.14563 8.50001C0.14563 6.82883 0.611081 5.31095 1.54198 3.94637C2.47271 2.58178 3.70865 1.56963 5.2498 0.909905V2.38022C4.10396 2.9705 3.19251 3.81234 2.51542 4.90574C1.83834 5.99914 1.4998 7.19706 1.4998 8.49949C1.4998 9.80192 1.83834 10.9957 2.51542 12.0807C3.19251 13.1658 4.10396 14.0122 5.2498 14.6198V16.0901ZM14.6253 16.7292C13.4831 16.7292 12.4131 16.5133 11.4152 16.0815C10.4172 15.6498 9.54711 15.0626 8.80474 14.3201C8.06221 13.5777 7.47506 12.7077 7.04329 11.7102C6.61152 10.7126 6.39563 9.64272 6.39563 8.50053C6.39563 7.35834 6.61152 6.28829 7.04329 5.29038C7.47506 4.29246 8.06221 3.42232 8.80474 2.67996C9.54711 1.93742 10.4171 1.35027 11.4146 0.9185C12.4122 0.486729 13.4821 0.270844 14.6243 0.270844C15.7665 0.270844 16.8365 0.486729 17.8344 0.9185C18.8323 1.35027 19.7025 1.93742 20.4449 2.67996C21.1874 3.42232 21.7745 4.29228 22.2063 5.28985C22.6381 6.28742 22.854 7.3573 22.854 8.49949C22.854 9.64168 22.6381 10.7117 22.2063 11.7096C21.7745 12.7076 21.1874 13.5777 20.4449 14.3201C19.7025 15.0626 18.8325 15.6498 17.835 16.0815C16.8374 16.5133 15.7675 16.7292 14.6253 16.7292ZM14.6191 15.375C16.5326 15.375 18.1578 14.7085 19.4946 13.3755C20.8314 12.0425 21.4998 10.4193 21.4998 8.50574C21.4998 6.5922 20.8333 4.96702 19.5003 3.63022C18.1673 2.29341 16.5441 1.62501 14.6305 1.62501C12.717 1.62501 11.0918 2.2915 9.755 3.62449C8.4182 4.95748 7.7498 6.58074 7.7498 8.49428C7.7498 10.4078 8.41629 12.033 9.74928 13.3698C11.0823 14.7066 12.7055 15.375 14.6191 15.375Z" fill="currentColor"/> <path d="M15.3019 9.16668H15.2915V9.17709V11.8789H13.9581V9.17709V9.16668H13.9477H11.2459V7.83334H13.9477H13.9581V7.82293V5.1211H15.2915V7.82293V7.83334H15.3019H18.0037V9.16668H15.3019ZM5.23938 16.0747C3.6895 15.4501 2.45566 14.4532 1.53762 13.0838C0.616564 11.7102 0.156047 10.1824 0.156047 8.50001C0.156047 6.8309 0.620881 5.31507 1.55059 3.95224C2.47726 2.5936 3.70678 1.5848 5.23938 0.92571V2.37387C4.09452 2.96487 3.18353 3.80704 2.50657 4.90026C1.82845 5.99533 1.48938 7.19515 1.48938 8.49949C1.48938 9.80383 1.82845 10.9995 2.50658 12.0863C3.18356 13.1712 4.09455 14.0178 5.23938 14.6261V16.0747ZM14.6253 16.7188C13.4845 16.7188 12.4158 16.5031 11.4193 16.072C10.4225 15.6407 9.55351 15.0543 8.81211 14.3127C8.07054 13.5713 7.48411 12.7024 7.05285 11.706C6.62167 10.7098 6.40605 9.64137 6.40605 8.50053C6.40605 7.35969 6.62167 6.29106 7.05285 5.29451C7.48411 4.29776 8.07054 3.42872 8.81211 2.68733C9.55351 1.94575 10.4224 1.35933 11.4188 0.928059C12.415 0.496882 13.4834 0.28126 14.6243 0.28126C15.7651 0.28126 16.8338 0.496882 17.8303 0.92806C18.8271 1.35933 19.6961 1.94575 20.4375 2.68732C21.1791 3.42873 21.7655 4.29758 22.1967 5.29399C22.6279 6.29019 22.8435 7.35865 22.8435 8.49949C22.8435 9.64033 22.6279 10.709 22.1967 11.7055C21.7655 12.7023 21.1791 13.5713 20.4375 14.3127C19.6961 15.0543 18.8272 15.6407 17.8308 16.072C16.8346 16.5031 15.7662 16.7188 14.6253 16.7188ZM14.6191 15.3854C16.5353 15.3854 18.1632 14.7179 19.5019 13.3829C20.8407 12.0479 21.5102 10.422 21.5102 8.50574C21.5102 6.58948 20.8427 4.96165 19.5077 3.62286C18.1727 2.28407 16.5468 1.61459 14.6305 1.61459C12.7143 1.61459 11.0864 2.28215 9.74765 3.61711C8.40885 4.95208 7.73938 6.57801 7.73938 8.49428C7.73938 10.4105 8.40694 12.0384 9.7419 13.3772C11.0769 14.716 12.7028 15.3854 14.6191 15.3854Z" stroke="currentColor" stroke-opacity="0.05" stroke-width="0.0208333"/> </svg>',
                'models'      => [
                    'freepik',
                    'gpt-image-1',
                    'flux-pro/kontext',
                ],
            ],
            [
                'show'        => (bool) setting('novita_api_key'),
                'action'      => 'remove_background',
                'model'	      => setting('remove_background_model', 'novita') ?? 'novita',
                'image'       => 'assets/img/advanced-image/enhance/remove-background.jpg',
                'title'       => 'Remove Background',
                'description' => 'Instantly remove backgrounds to create transparent images. ',
                'premium'     => false,
                'icon'        => '<svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"> <mask id="path-1-inside-1_34_206" fill="white"> <path d="M3.60525 11.7C3.35175 11.7 3.1375 11.6143 2.9625 11.4428C2.7875 11.2713 2.7 11.0588 2.7 10.8053C2.7 10.5518 2.78575 10.3375 2.95725 10.1625C3.12875 9.9875 3.34125 9.9 3.59475 9.9C3.84825 9.9 4.0625 9.98575 4.2375 10.1573C4.4125 10.3288 4.5 10.5413 4.5 10.7948C4.5 11.0483 4.41425 11.2625 4.24275 11.4375C4.07125 11.6125 3.85875 11.7 3.60525 11.7ZM3.60525 15.3C3.35175 15.3 3.1375 15.2143 2.9625 15.0428C2.7875 14.8713 2.7 14.6587 2.7 14.4052C2.7 14.1517 2.78575 13.9375 2.95725 13.7625C3.12875 13.5875 3.34125 13.5 3.59475 13.5C3.84825 13.5 4.0625 13.5858 4.2375 13.7573C4.4125 13.9288 4.5 14.1413 4.5 14.3948C4.5 14.6483 4.41425 14.8625 4.24275 15.0375C4.07125 15.2125 3.85875 15.3 3.60525 15.3ZM3.60525 8.1C3.35175 8.1 3.1375 8.01425 2.9625 7.84275C2.7875 7.67125 2.7 7.45875 2.7 7.20525C2.7 6.95175 2.78575 6.7375 2.95725 6.5625C3.12875 6.3875 3.34125 6.3 3.59475 6.3C3.84825 6.3 4.0625 6.38575 4.2375 6.55725C4.4125 6.72875 4.5 6.94125 4.5 7.19475C4.5 7.44825 4.41425 7.6625 4.24275 7.8375C4.07125 8.0125 3.85875 8.1 3.60525 8.1ZM0.6 7.8C0.44 7.8 0.3 7.74 0.18 7.62C0.0599999 7.5 0 7.36 0 7.2C0 7.04 0.0599999 6.9 0.18 6.78C0.3 6.66 0.44 6.6 0.6 6.6C0.76 6.6 0.9 6.66 1.02 6.78C1.14 6.9 1.2 7.04 1.2 7.2C1.2 7.36 1.14 7.5 1.02 7.62C0.9 7.74 0.76 7.8 0.6 7.8ZM3.60525 4.5C3.35175 4.5 3.1375 4.41425 2.9625 4.24275C2.7875 4.07125 2.7 3.85875 2.7 3.60525C2.7 3.35175 2.78575 3.1375 2.95725 2.9625C3.12875 2.7875 3.34125 2.7 3.59475 2.7C3.84825 2.7 4.0625 2.78575 4.2375 2.95725C4.4125 3.12875 4.5 3.34125 4.5 3.59475C4.5 3.84825 4.41425 4.0625 4.24275 4.2375C4.07125 4.4125 3.85875 4.5 3.60525 4.5ZM0.6 11.4C0.44 11.4 0.3 11.34 0.18 11.22C0.0599999 11.1 0 10.96 0 10.8C0 10.64 0.0599999 10.5 0.18 10.38C0.3 10.26 0.44 10.2 0.6 10.2C0.76 10.2 0.9 10.26 1.02 10.38C1.14 10.5 1.2 10.64 1.2 10.8C1.2 10.96 1.14 11.1 1.02 11.22C0.9 11.34 0.76 11.4 0.6 11.4ZM7.2 18C7.04 18 6.9 17.94 6.78 17.82C6.66 17.7 6.6 17.56 6.6 17.4C6.6 17.24 6.66 17.1 6.78 16.98C6.9 16.86 7.04 16.8 7.2 16.8C7.36 16.8 7.5 16.86 7.62 16.98C7.74 17.1 7.8 17.24 7.8 17.4C7.8 17.56 7.74 17.7 7.62 17.82C7.5 17.94 7.36 18 7.2 18ZM7.2 1.2C7.04 1.2 6.9 1.14 6.78 1.02C6.66 0.9 6.6 0.76 6.6 0.6C6.6 0.44 6.66 0.3 6.78 0.18C6.9 0.0600003 7.04 0 7.2 0C7.36 0 7.5 0.0600003 7.62 0.18C7.74 0.3 7.8 0.44 7.8 0.6C7.8 0.76 7.74 0.9 7.62 1.02C7.5 1.14 7.36 1.2 7.2 1.2ZM7.20525 4.5C6.95175 4.5 6.7375 4.41425 6.5625 4.24275C6.3875 4.07125 6.3 3.85875 6.3 3.60525C6.3 3.35175 6.38575 3.1375 6.55725 2.9625C6.72875 2.7875 6.94125 2.7 7.19475 2.7C7.44825 2.7 7.6625 2.78575 7.8375 2.95725C8.0125 3.12875 8.1 3.34125 8.1 3.59475C8.1 3.84825 8.01425 4.0625 7.84275 4.2375C7.67125 4.4125 7.45875 4.5 7.20525 4.5ZM7.2 12C6.86667 12 6.58333 11.8833 6.35 11.65C6.11667 11.4167 6 11.1333 6 10.8C6 10.4667 6.11667 10.1833 6.35 9.95C6.58333 9.71667 6.86667 9.6 7.2 9.6C7.53333 9.6 7.81667 9.71667 8.05 9.95C8.28333 10.1833 8.4 10.4667 8.4 10.8C8.4 11.1333 8.28333 11.4167 8.05 11.65C7.81667 11.8833 7.53333 12 7.2 12ZM7.2 8.4C6.86667 8.4 6.58333 8.28333 6.35 8.05C6.11667 7.81667 6 7.53333 6 7.2C6 6.86667 6.11667 6.58333 6.35 6.35C6.58333 6.11667 6.86667 6 7.2 6C7.53333 6 7.81667 6.11667 8.05 6.35C8.28333 6.58333 8.4 6.86667 8.4 7.2C8.4 7.53333 8.28333 7.81667 8.05 8.05C7.81667 8.28333 7.53333 8.4 7.2 8.4ZM7.20525 15.3C6.95175 15.3 6.7375 15.2143 6.5625 15.0428C6.3875 14.8713 6.3 14.6587 6.3 14.4052C6.3 14.1517 6.38575 13.9375 6.55725 13.7625C6.72875 13.5875 6.94125 13.5 7.19475 13.5C7.44825 13.5 7.6625 13.5858 7.8375 13.7573C8.0125 13.9288 8.1 14.1413 8.1 14.3948C8.1 14.6483 8.01425 14.8625 7.84275 15.0375C7.67125 15.2125 7.45875 15.3 7.20525 15.3ZM9 17.4V15.6C10.8333 15.5833 12.3917 14.9331 13.675 13.6493C14.9583 12.3654 15.6 10.8154 15.6 8.99925C15.6 7.18308 14.9583 5.63333 13.675 4.35C12.3917 3.06667 10.8333 2.41667 9 2.4V0.6C10.15 0.616667 11.2375 0.845833 12.2625 1.2875C13.2875 1.72917 14.1793 2.33017 14.938 3.0905C15.6968 3.85083 16.2968 4.73917 16.738 5.7555C17.1793 6.772 17.4 7.85433 17.4 9.0025C17.4 10.1508 17.1793 11.2327 16.738 12.248C16.2968 13.2635 15.6968 14.151 14.938 14.9105C14.1793 15.6702 13.2875 16.2708 12.2625 16.7125C11.2375 17.1542 10.15 17.3833 9 17.4Z"/> </mask> <path d="M3.60525 11.7C3.35175 11.7 3.1375 11.6143 2.9625 11.4428C2.7875 11.2713 2.7 11.0588 2.7 10.8053C2.7 10.5518 2.78575 10.3375 2.95725 10.1625C3.12875 9.9875 3.34125 9.9 3.59475 9.9C3.84825 9.9 4.0625 9.98575 4.2375 10.1573C4.4125 10.3288 4.5 10.5413 4.5 10.7948C4.5 11.0483 4.41425 11.2625 4.24275 11.4375C4.07125 11.6125 3.85875 11.7 3.60525 11.7ZM3.60525 15.3C3.35175 15.3 3.1375 15.2143 2.9625 15.0428C2.7875 14.8713 2.7 14.6587 2.7 14.4052C2.7 14.1517 2.78575 13.9375 2.95725 13.7625C3.12875 13.5875 3.34125 13.5 3.59475 13.5C3.84825 13.5 4.0625 13.5858 4.2375 13.7573C4.4125 13.9288 4.5 14.1413 4.5 14.3948C4.5 14.6483 4.41425 14.8625 4.24275 15.0375C4.07125 15.2125 3.85875 15.3 3.60525 15.3ZM3.60525 8.1C3.35175 8.1 3.1375 8.01425 2.9625 7.84275C2.7875 7.67125 2.7 7.45875 2.7 7.20525C2.7 6.95175 2.78575 6.7375 2.95725 6.5625C3.12875 6.3875 3.34125 6.3 3.59475 6.3C3.84825 6.3 4.0625 6.38575 4.2375 6.55725C4.4125 6.72875 4.5 6.94125 4.5 7.19475C4.5 7.44825 4.41425 7.6625 4.24275 7.8375C4.07125 8.0125 3.85875 8.1 3.60525 8.1ZM0.6 7.8C0.44 7.8 0.3 7.74 0.18 7.62C0.0599999 7.5 0 7.36 0 7.2C0 7.04 0.0599999 6.9 0.18 6.78C0.3 6.66 0.44 6.6 0.6 6.6C0.76 6.6 0.9 6.66 1.02 6.78C1.14 6.9 1.2 7.04 1.2 7.2C1.2 7.36 1.14 7.5 1.02 7.62C0.9 7.74 0.76 7.8 0.6 7.8ZM3.60525 4.5C3.35175 4.5 3.1375 4.41425 2.9625 4.24275C2.7875 4.07125 2.7 3.85875 2.7 3.60525C2.7 3.35175 2.78575 3.1375 2.95725 2.9625C3.12875 2.7875 3.34125 2.7 3.59475 2.7C3.84825 2.7 4.0625 2.78575 4.2375 2.95725C4.4125 3.12875 4.5 3.34125 4.5 3.59475C4.5 3.84825 4.41425 4.0625 4.24275 4.2375C4.07125 4.4125 3.85875 4.5 3.60525 4.5ZM0.6 11.4C0.44 11.4 0.3 11.34 0.18 11.22C0.0599999 11.1 0 10.96 0 10.8C0 10.64 0.0599999 10.5 0.18 10.38C0.3 10.26 0.44 10.2 0.6 10.2C0.76 10.2 0.9 10.26 1.02 10.38C1.14 10.5 1.2 10.64 1.2 10.8C1.2 10.96 1.14 11.1 1.02 11.22C0.9 11.34 0.76 11.4 0.6 11.4ZM7.2 18C7.04 18 6.9 17.94 6.78 17.82C6.66 17.7 6.6 17.56 6.6 17.4C6.6 17.24 6.66 17.1 6.78 16.98C6.9 16.86 7.04 16.8 7.2 16.8C7.36 16.8 7.5 16.86 7.62 16.98C7.74 17.1 7.8 17.24 7.8 17.4C7.8 17.56 7.74 17.7 7.62 17.82C7.5 17.94 7.36 18 7.2 18ZM7.2 1.2C7.04 1.2 6.9 1.14 6.78 1.02C6.66 0.9 6.6 0.76 6.6 0.6C6.6 0.44 6.66 0.3 6.78 0.18C6.9 0.0600003 7.04 0 7.2 0C7.36 0 7.5 0.0600003 7.62 0.18C7.74 0.3 7.8 0.44 7.8 0.6C7.8 0.76 7.74 0.9 7.62 1.02C7.5 1.14 7.36 1.2 7.2 1.2ZM7.20525 4.5C6.95175 4.5 6.7375 4.41425 6.5625 4.24275C6.3875 4.07125 6.3 3.85875 6.3 3.60525C6.3 3.35175 6.38575 3.1375 6.55725 2.9625C6.72875 2.7875 6.94125 2.7 7.19475 2.7C7.44825 2.7 7.6625 2.78575 7.8375 2.95725C8.0125 3.12875 8.1 3.34125 8.1 3.59475C8.1 3.84825 8.01425 4.0625 7.84275 4.2375C7.67125 4.4125 7.45875 4.5 7.20525 4.5ZM7.2 12C6.86667 12 6.58333 11.8833 6.35 11.65C6.11667 11.4167 6 11.1333 6 10.8C6 10.4667 6.11667 10.1833 6.35 9.95C6.58333 9.71667 6.86667 9.6 7.2 9.6C7.53333 9.6 7.81667 9.71667 8.05 9.95C8.28333 10.1833 8.4 10.4667 8.4 10.8C8.4 11.1333 8.28333 11.4167 8.05 11.65C7.81667 11.8833 7.53333 12 7.2 12ZM7.2 8.4C6.86667 8.4 6.58333 8.28333 6.35 8.05C6.11667 7.81667 6 7.53333 6 7.2C6 6.86667 6.11667 6.58333 6.35 6.35C6.58333 6.11667 6.86667 6 7.2 6C7.53333 6 7.81667 6.11667 8.05 6.35C8.28333 6.58333 8.4 6.86667 8.4 7.2C8.4 7.53333 8.28333 7.81667 8.05 8.05C7.81667 8.28333 7.53333 8.4 7.2 8.4ZM7.20525 15.3C6.95175 15.3 6.7375 15.2143 6.5625 15.0428C6.3875 14.8713 6.3 14.6587 6.3 14.4052C6.3 14.1517 6.38575 13.9375 6.55725 13.7625C6.72875 13.5875 6.94125 13.5 7.19475 13.5C7.44825 13.5 7.6625 13.5858 7.8375 13.7573C8.0125 13.9288 8.1 14.1413 8.1 14.3948C8.1 14.6483 8.01425 14.8625 7.84275 15.0375C7.67125 15.2125 7.45875 15.3 7.20525 15.3ZM9 17.4V15.6C10.8333 15.5833 12.3917 14.9331 13.675 13.6493C14.9583 12.3654 15.6 10.8154 15.6 8.99925C15.6 7.18308 14.9583 5.63333 13.675 4.35C12.3917 3.06667 10.8333 2.41667 9 2.4V0.6C10.15 0.616667 11.2375 0.845833 12.2625 1.2875C13.2875 1.72917 14.1793 2.33017 14.938 3.0905C15.6968 3.85083 16.2968 4.73917 16.738 5.7555C17.1793 6.772 17.4 7.85433 17.4 9.0025C17.4 10.1508 17.1793 11.2327 16.738 12.248C16.2968 13.2635 15.6968 14.151 14.938 14.9105C14.1793 15.6702 13.2875 16.2708 12.2625 16.7125C11.2375 17.1542 10.15 17.3833 9 17.4Z" fill="currentColor" stroke="currentColor" stroke-opacity="0.05" stroke-width="0.0416667" mask="url(#path-1-inside-1_34_206)"/> </svg>',
                'models'      => [
                    'freepik',
                    //                    'flux-pro/kontext',
                    //                    'gpt-image-1',
                ],
            ],
            [
                'show'        => (bool) setting('novita_api_key'),
                'action'      => 'cleanup',
                'model'	      => setting('cleanup_model', 'novita') ?? 'novita',
                'image'       => 'assets/img/advanced-image/enhance/cleanup.jpg',
                'title'       => 'Cleanup',
                'description' => 'Effortlessly remove unwanted objects or imperfections from your images.',
                'premium'     => false,
                'icon'        => '<svg width="23" height="20" viewBox="0 0 23 20" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M1.50671 11.3513C2.74006 9.62782 6.4772 4.72986 10.8517 1.97472C14.1406 -0.0967112 17.2467 2.6378 14.8381 5.39161C12.4823 8.08491 9.32288 11.7916 7.97422 13.6321C6.57657 15.5395 8.96895 17.846 11.3636 15.6504C12.9639 14.1831 14.6314 12.4951 16.3265 11.2478C18.6142 9.56454 20.5763 11.0509 19.5776 12.9483C18.856 14.3194 18.3329 14.9252 17.7299 16.0791C17.1271 17.2332 17.7651 18.617 18.6788 18.7356C19.8105 18.8827 20.5263 18.0715 21.4934 16.8065" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                'models'      => [
                    'novita',
                    'gpt-image-1',
                    'flux-pro/kontext',
                ],
            ],
            [
                'show'        => (bool) setting('freepik_api_key'),
                'action'      => 'upscale',
                'model'       => 'freepik',
                'image'       => 'assets/img/advanced-image/enhance/upscaler.jpg',
                'title'       => 'Upscaler',
                'description' => 'Enhance image resolution without losing detail or clarity.',
                'premium'     => false,
                'icon'        => '<svg width="21" height="17" viewBox="0 0 21 17" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M9.5 15.5H3.5C2.96957 15.5 2.46086 15.2893 2.08579 14.9142C1.71071 14.5391 1.5 14.0304 1.5 13.5V3.5C1.5 2.96957 1.71071 2.46086 2.08579 2.08579C2.46086 1.71071 2.96957 1.5 3.5 1.5H17.5C18.0304 1.5 18.5391 1.71071 18.9142 2.08579C19.2893 2.46086 19.5 2.96957 19.5 3.5V7.5M12.5 11.5C12.5 11.2348 12.6054 10.9804 12.7929 10.7929C12.9804 10.6054 13.2348 10.5 13.5 10.5H18.5C18.7652 10.5 19.0196 10.6054 19.2071 10.7929C19.3946 10.9804 19.5 11.2348 19.5 11.5V14.5C19.5 14.7652 19.3946 15.0196 19.2071 15.2071C19.0196 15.3946 18.7652 15.5 18.5 15.5H13.5C13.2348 15.5 12.9804 15.3946 12.7929 15.2071C12.6054 15.0196 12.5 14.7652 12.5 14.5V11.5Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/> </svg>',
                'models'      => [
                    'freepik',

                ],
            ],
            [
                'show'        => (bool) setting('novita_api_key'),
                'action'      => 'replace_background',
                'model'       => 'novita',
                'image'       => 'assets/img/advanced-image/enhance/replace-background.jpg',
                'title'       => 'Replace Background',
                'description' => 'Easily change the background of any image to create a new setting.',
                'premium'     => false,
                'icon'        => '<svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M8.98075 11.5V10.3558C8.98075 9.97758 9.11217 9.65708 9.375 9.39425C9.63783 9.13142 9.95833 9 10.3365 9H11.4808L8.98075 11.5ZM8.98075 15.4193V13.727L13.7172 9H15.4095L8.98075 15.4193ZM9.0405 17.6213L17.6057 9.0405C17.8211 9.08783 18.0053 9.18808 18.1585 9.34125C18.3118 9.49458 18.4122 9.67892 18.4595 9.89425L9.87875 18.4595C9.66342 18.4083 9.48267 18.3097 9.3365 18.1635C9.19033 18.0173 9.09167 17.8366 9.0405 17.6213ZM12.0807 18.5L18.5 12.0808V13.7635L13.773 18.5H12.0807ZM16 18.5L18.5 16V17.1443C18.5 17.5224 18.3686 17.8429 18.1057 18.1057C17.8429 18.3686 17.5224 18.5 17.1443 18.5H16ZM17.198 6.80775H15.6423C15.1833 5.39875 14.3535 4.24517 13.153 3.347C11.9523 2.449 10.568 2 9 2C7.05 2 5.39583 2.67917 4.0375 4.0375C2.67917 5.39583 2 7.05 2 9C2 10.3025 2.3205 11.4843 2.9615 12.5452C3.6025 13.6061 4.44867 14.4339 5.5 15.0288V12H7V17.5H1.5V16H4.33075C3.17575 15.25 2.2485 14.2644 1.549 13.0433C0.849667 11.8221 0.5 10.4743 0.5 9C0.5 7.8205 0.723083 6.71542 1.16925 5.68475C1.61542 4.65392 2.22183 3.75517 2.9885 2.9885C3.75517 2.22183 4.65392 1.61542 5.68475 1.16925C6.71542 0.723084 7.8205 0.5 9 0.5C10.9768 0.5 12.7169 1.09517 14.2203 2.2855C15.7234 3.476 16.716 4.98342 17.198 6.80775Z" fill="currentColor"/> </svg>',
                'models'      => [
                    'novita',
                    'flux-pro/kontext',
                ],
            ],
            [
                'show'        => (bool) setting('clipdrop_api_key') || Helper::setOpenAiKey(),
                'action'      => 'sketch_to_image',
                'model'       => setting('sketch_to_image_model', 'clipdrop') ?? 'clipdrop',
                'image'       => 'assets/img/advanced-image/enhance/sketch-to-image.jpg',
                'title'       => 'Sketch to Image',
                'description' => 'Turn simple sketches into detailed, realistic images.',
                'premium'     => false,
                'icon'        => '<svg width="19" height="18" viewBox="0 0 19 18" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M1.5 17.5V14.125L14.6943 0.946249C14.8494 0.791083 15.0199 0.677917 15.2057 0.60675C15.3917 0.535584 15.5777 0.5 15.7635 0.5C15.9597 0.5 16.1497 0.535584 16.3337 0.60675C16.5176 0.677917 16.6788 0.791083 16.8173 0.946249L18.0538 2.18275C18.2089 2.32125 18.3221 2.48242 18.3932 2.66625C18.4644 2.85025 18.5 3.04033 18.5 3.2365C18.5 3.42233 18.4644 3.60825 18.3932 3.79425C18.3221 3.98008 18.2089 4.15058 18.0538 4.30575L4.875 17.5H1.5ZM3 16H4.2365L14.427 5.825L13.8135 5.1865L13.175 4.573L3 14.7635V16ZM13.8135 5.1865L13.175 4.573L14.427 5.825L13.8135 5.1865ZM11.1348 17.5C12.3039 17.5 13.3878 17.2141 14.3865 16.6423C15.3852 16.0704 15.8845 15.273 15.8845 14.25C15.8845 13.6628 15.7086 13.1493 15.3568 12.7095C15.0048 12.2698 14.5108 11.8981 13.875 11.5942L12.7557 12.7135C13.2673 12.9058 13.6666 13.1324 13.9538 13.3932C14.2411 13.6541 14.3848 13.9397 14.3848 14.25C14.3848 14.723 14.0598 15.1329 13.4098 15.4798C12.7598 15.8266 12.0014 16 11.1348 16C10.9219 16 10.7437 16.0718 10.6 16.2155C10.4565 16.359 10.3848 16.5372 10.3848 16.75C10.3848 16.9628 10.4565 17.141 10.6 17.2845C10.7437 17.4282 10.9219 17.5 11.1348 17.5ZM2.09425 10.4365L3.20975 9.3115C2.81858 9.14617 2.51917 8.975 2.3115 8.798C2.10383 8.62117 2 8.4385 2 8.25C2 7.99867 2.16767 7.75058 2.503 7.50575C2.83817 7.26092 3.50508 6.92375 4.50375 6.49425C5.89358 5.89942 6.82375 5.36125 7.29425 4.87975C7.76475 4.39842 8 3.85517 8 3.25C8 2.4295 7.65417 1.76608 6.9625 1.25975C6.27083 0.75325 5.36667 0.5 4.25 0.5C3.56417 0.5 2.93342 0.623749 2.35775 0.871249C1.78208 1.11858 1.35192 1.42117 1.06725 1.779C0.928917 1.94433 0.871583 2.12667 0.89525 2.326C0.918917 2.52533 1.0135 2.68908 1.179 2.81725C1.34433 2.94942 1.52508 3.00358 1.72125 2.97975C1.91742 2.95608 2.08467 2.875 2.223 2.7365C2.47567 2.484 2.76608 2.29808 3.09425 2.17875C3.42242 2.05958 3.80767 2 4.25 2C4.98467 2 5.54333 2.124 5.926 2.372C6.30867 2.62017 6.5 2.91283 6.5 3.25C6.5 3.541 6.33492 3.80483 6.00475 4.0415C5.67475 4.278 4.97508 4.63792 3.90575 5.12125C2.61725 5.68525 1.7275 6.19033 1.2365 6.6365C0.7455 7.08267 0.5 7.6205 0.5 8.25C0.5 8.71917 0.640083 9.13167 0.92025 9.4875C1.20042 9.84333 1.59175 10.1597 2.09425 10.4365Z" fill="currentColor"/> </svg>',
                'models'      => [
                    'clipdrop',
                    'flux-pro/kontext',
                ],
            ],
            [
                'show'        => (bool) setting('novita_api_key'),
                'action'      => 'remove_text',
                'model'       => setting('remove_text_model', 'novita') ?? 'novita',
                'image'       => 'assets/img/advanced-image/enhance/remove_text.png',
                'title'       => 'Remove Text',
                'description' => 'Remove or eliminate unwanted text from images while preserving the background.',
                'premium'     => false,
                'icon'        => '<svg   xmlns="http://www.w3.org/2000/svg"   width="24"   height="24"   viewBox="0 0 24 24"   fill="none"   stroke="currentColor"   stroke-width="2"   stroke-linecap="round"   stroke-linejoin="round" >   <path d="M19 20h-10.5l-4.21 -4.3a1 1 0 0 1 0 -1.41l10 -10a1 1 0 0 1 1.41 0l5 5a1 1 0 0 1 0 1.41l-9.2 9.3" />   <path d="M18 13.3l-6.3 -6.3" /> </svg>',
                'models'      => [
                    'novita',
                    'gpt-image-1',
                    'flux-pro/kontext',
                ],
            ],
            [
                'show'        => (bool) setting('novita_api_key') || Helper::setOpenAiKey(),
                'action'      => 'inpainting',
                'model'       => setting('inpainting_model', 'novita') ?? 'novita',
                'image'       => 'assets/img/advanced-image/enhance/inpainting.jpg',
                'title'       => 'Inpainting',
                'description' => 'Seamlessly add new elements to your photos using AI-powered suggestions.',
                'premium'     => false,
                'icon'        => '<svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M1.55375 17.5C1.31408 17.4397 1.09358 17.3089 0.89225 17.1077C0.691083 16.9064 0.560333 16.6859 0.5 16.4462L16.4462 0.5C16.7064 0.5705 16.9294 0.70125 17.1152 0.89225C17.3013 1.08325 17.4346 1.30375 17.5152 1.55375L1.55375 17.5ZM0.5 11.1135V9.00575L9.00575 0.5H11.1135L0.5 11.1135ZM0.5 3.673V2.30775C0.5 1.80258 0.675 1.375 1.025 1.025C1.375 0.675 1.80258 0.5 2.30775 0.5H3.673L0.5 3.673ZM17.5 6.8865V8.99425L17.1788 9.31525C16.9288 9.19358 16.666 9.09492 16.3905 9.01925C16.1148 8.94358 15.8282 8.88908 15.5307 8.85575L17.5 6.8865ZM6.8865 17.5L9.0865 15.3C9.11983 15.5975 9.17433 15.884 9.25 16.1595C9.32567 16.4352 9.42442 16.698 9.54625 16.948L8.99425 17.5H6.8865ZM14 15.2693H11V13.7693H14V10.7692H15.5V13.7693H18.5V15.2693H15.5V18.2693H14V15.2693Z" fill="currentColor"/> </svg>',
                'models'      => [
                    'novita',
                    'gpt-image-1',
                    'flux-pro/kontext',
                ],
            ],
            [
                'show'        => (bool) setting('freepik_api_key'),
                'action'      => 'style_transfer',
                'model'       => setting('style_transfer_model', 'freepik') ?? 'freepik',
                'image'       => 'assets/img/advanced-image/enhance/style-transfer.png',
                'title'       => 'Style Transfer',
                'description' => 'Ensure stylistic consistency by transferring the style of your image.',
                'premium'     => false,
                'icon'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19 19" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" width="19" height="19" stroke-width="2"> <path d="M20 10h-16l5.5 -6"></path> <path d="M4 14h16l-5.5 6"></path> </svg> ',
                'models'      => [
                    'freepik',
                    'gpt-image-1',
                    'flux-pro/kontext',
                ],
            ],
            [
                'show'        => (bool) setting('freepik_api_key'),
                'action'      => 'image_relight',
                'model'       => setting('image_relight_model', 'freepik') ?? 'freepik',
                'image'       => 'assets/img/advanced-image/enhance/reimagine.jpg',
                'title'       => 'Image relight',
                'description' => 'Relight an image using AI.',
                'premium'     => false,
                'icon'        => '<svg width="23" height="17" viewBox="0 0 23 17" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M13.9477 11.8893H15.3019V9.17709H18.0141V7.82293H15.3019V5.11069H13.9477V7.82293H11.2355V9.17709H13.9477V11.8893ZM5.2498 16.0901C3.69129 15.4651 2.45101 14.4649 1.52896 13.0896C0.606741 11.7142 0.14563 10.1844 0.14563 8.50001C0.14563 6.82883 0.611081 5.31095 1.54198 3.94637C2.47271 2.58178 3.70865 1.56963 5.2498 0.909905V2.38022C4.10396 2.9705 3.19251 3.81234 2.51542 4.90574C1.83834 5.99914 1.4998 7.19706 1.4998 8.49949C1.4998 9.80192 1.83834 10.9957 2.51542 12.0807C3.19251 13.1658 4.10396 14.0122 5.2498 14.6198V16.0901ZM14.6253 16.7292C13.4831 16.7292 12.4131 16.5133 11.4152 16.0815C10.4172 15.6498 9.54711 15.0626 8.80474 14.3201C8.06221 13.5777 7.47506 12.7077 7.04329 11.7102C6.61152 10.7126 6.39563 9.64272 6.39563 8.50053C6.39563 7.35834 6.61152 6.28829 7.04329 5.29038C7.47506 4.29246 8.06221 3.42232 8.80474 2.67996C9.54711 1.93742 10.4171 1.35027 11.4146 0.9185C12.4122 0.486729 13.4821 0.270844 14.6243 0.270844C15.7665 0.270844 16.8365 0.486729 17.8344 0.9185C18.8323 1.35027 19.7025 1.93742 20.4449 2.67996C21.1874 3.42232 21.7745 4.29228 22.2063 5.28985C22.6381 6.28742 22.854 7.3573 22.854 8.49949C22.854 9.64168 22.6381 10.7117 22.2063 11.7096C21.7745 12.7076 21.1874 13.5777 20.4449 14.3201C19.7025 15.0626 18.8325 15.6498 17.835 16.0815C16.8374 16.5133 15.7675 16.7292 14.6253 16.7292ZM14.6191 15.375C16.5326 15.375 18.1578 14.7085 19.4946 13.3755C20.8314 12.0425 21.4998 10.4193 21.4998 8.50574C21.4998 6.5922 20.8333 4.96702 19.5003 3.63022C18.1673 2.29341 16.5441 1.62501 14.6305 1.62501C12.717 1.62501 11.0918 2.2915 9.755 3.62449C8.4182 4.95748 7.7498 6.58074 7.7498 8.49428C7.7498 10.4078 8.41629 12.033 9.74928 13.3698C11.0823 14.7066 12.7055 15.375 14.6191 15.375Z" fill="currentColor"/> <path d="M15.3019 9.16668H15.2915V9.17709V11.8789H13.9581V9.17709V9.16668H13.9477H11.2459V7.83334H13.9477H13.9581V7.82293V5.1211H15.2915V7.82293V7.83334H15.3019H18.0037V9.16668H15.3019ZM5.23938 16.0747C3.6895 15.4501 2.45566 14.4532 1.53762 13.0838C0.616564 11.7102 0.156047 10.1824 0.156047 8.50001C0.156047 6.8309 0.620881 5.31507 1.55059 3.95224C2.47726 2.5936 3.70678 1.5848 5.23938 0.92571V2.37387C4.09452 2.96487 3.18353 3.80704 2.50657 4.90026C1.82845 5.99533 1.48938 7.19515 1.48938 8.49949C1.48938 9.80383 1.82845 10.9995 2.50658 12.0863C3.18356 13.1712 4.09455 14.0178 5.23938 14.6261V16.0747ZM14.6253 16.7188C13.4845 16.7188 12.4158 16.5031 11.4193 16.072C10.4225 15.6407 9.55351 15.0543 8.81211 14.3127C8.07054 13.5713 7.48411 12.7024 7.05285 11.706C6.62167 10.7098 6.40605 9.64137 6.40605 8.50053C6.40605 7.35969 6.62167 6.29106 7.05285 5.29451C7.48411 4.29776 8.07054 3.42872 8.81211 2.68733C9.55351 1.94575 10.4224 1.35933 11.4188 0.928059C12.415 0.496882 13.4834 0.28126 14.6243 0.28126C15.7651 0.28126 16.8338 0.496882 17.8303 0.92806C18.8271 1.35933 19.6961 1.94575 20.4375 2.68732C21.1791 3.42873 21.7655 4.29758 22.1967 5.29399C22.6279 6.29019 22.8435 7.35865 22.8435 8.49949C22.8435 9.64033 22.6279 10.709 22.1967 11.7055C21.7655 12.7023 21.1791 13.5713 20.4375 14.3127C19.6961 15.0543 18.8272 15.6407 17.8308 16.072C16.8346 16.5031 15.7662 16.7188 14.6253 16.7188ZM14.6191 15.3854C16.5353 15.3854 18.1632 14.7179 19.5019 13.3829C20.8407 12.0479 21.5102 10.422 21.5102 8.50574C21.5102 6.58948 20.8427 4.96165 19.5077 3.62286C18.1727 2.28407 16.5468 1.61459 14.6305 1.61459C12.7143 1.61459 11.0864 2.28215 9.74765 3.61711C8.40885 4.95208 7.73938 6.57801 7.73938 8.49428C7.73938 10.4105 8.40694 12.0384 9.7419 13.3772C11.0769 14.716 12.7028 15.3854 14.6191 15.3854Z" stroke="currentColor" stroke-opacity="0.05" stroke-width="0.0208333"/> </svg>',
                'models'      => [
                    'freepik',
                    'flux-pro/kontext',
                ],
            ],
        ];

        $tools = array_filter($tools, function ($tool) {
            return $tool['show'];
        });

        return array_values($tools);
    }
}
