@php
    $advanced_options = [
        [
            'icon' => '<svg width="22" height="18" viewBox="0 0 22 18" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
				<path d="M18.7258 3.70231C17.403 3.70231 16.1674 3.0392 15.4368 1.93642C14.9954 1.27422 14.2228 0.876892 13.4281 0.876892H8.57194C7.77729 0.876892 7.00472 1.27422 6.56325 1.93642C5.83266 3.0392 4.59711 3.70231 3.27429 3.70231C1.9278 3.70231 0.846191 4.78392 0.846191 6.1304V14.695C0.846191 16.0414 1.9278 17.123 3.27429 17.123H18.7258C20.0723 17.123 21.1539 16.0414 21.1539 14.695V6.1304C21.1539 4.78392 20.0723 3.70231 18.7258 3.70231ZM11 15.1364C7.97596 15.1364 5.52579 12.6863 5.52579 9.66218C5.52579 6.6381 7.97596 4.21 11 4.21C14.0241 4.21 16.4743 6.66017 16.4743 9.68425C16.4743 12.6863 14.0241 15.1364 11 15.1364ZM18.4168 7.12371C18.3947 7.12371 18.3726 7.12371 18.3285 7.12371H17.4455C17.0482 7.10164 16.7392 6.77054 16.7612 6.37321C16.7833 5.99796 17.0703 5.71101 17.4455 5.68893H18.3285C18.7258 5.66686 19.0569 5.97589 19.079 6.37321C19.101 6.77054 18.8141 7.10164 18.4168 7.12371Z"/>
				<path d="M11 6.6381C9.32245 6.6381 7.95388 8.00666 7.95388 9.68425C7.95388 11.3618 9.32245 12.7083 11 12.7083C12.6776 12.7083 14.0462 11.3398 14.0462 9.66218C14.0462 7.98458 12.6776 6.6381 11 6.6381Z"/>
			</svg>',
            'label' => 'AI Product Photo',
            'link' => \App\Helpers\Classes\MarketplaceHelper::isRegistered('ai-product-shot') ? route('dashboard.user.ai-product-shot.index') : null,
        ],
        [
            'icon' =>
                '<svg width="21" height="17" viewBox="0 0 21 17" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M9.38497 6.86785C8.76819 7.27999 8.04305 7.49996 7.30125 7.49996C6.30694 7.49909 5.3536 7.10377 4.65046 6.40075C3.94732 5.69773 3.55182 4.74446 3.55078 3.75015C3.55065 3.00835 3.7705 2.28317 4.18253 1.66632C4.59456 1.04947 5.18026 0.568666 5.86555 0.284701C6.55085 0.000736028 7.30497 -0.0736292 8.03253 0.0710094C8.76009 0.215648 9.42842 0.572794 9.953 1.09728C10.4776 1.62177 10.8348 2.29004 10.9796 3.01757C11.1244 3.74511 11.0501 4.49924 10.7663 5.18459C10.4824 5.86993 10.0017 6.45571 9.38497 6.86785Z"/> <path d="M8.70481 8.6755C10.0374 8.95394 11.2568 9.62332 12.2072 10.5981C12.9549 11.3665 13.5104 12.3008 13.8281 13.3248C14.0415 13.9872 14.1489 14.6791 14.1464 15.375C14.1464 15.549 14.0773 15.7159 13.9542 15.839C13.8311 15.9621 13.6642 16.0312 13.4902 16.0312H1.11328C0.939233 16.0312 0.772313 15.9621 0.649242 15.839C0.526172 15.7159 0.457031 15.549 0.457031 15.375C0.457646 14.0136 0.864077 12.6832 1.62441 11.5539C2.38474 10.4246 3.46445 9.5476 4.72562 9.03488C5.9868 8.52217 7.37218 8.39705 8.70481 8.6755Z"/> <path d="M15.2227 7.82809C16.763 7.82809 18.0117 6.57939 18.0117 5.03903C18.0117 3.49868 16.763 2.24997 15.2227 2.24997C13.6823 2.24997 12.4336 3.49868 12.4336 5.03903C12.4336 6.57939 13.6823 7.82809 15.2227 7.82809Z"/> <path d="M12.7829 9.33985C12.755 9.31492 12.7593 9.27004 12.7917 9.25134C13.5314 8.82524 14.3698 8.59911 15.2242 8.5959C16.5292 8.59729 17.7803 9.11629 18.703 10.039C19.6257 10.9617 20.1447 12.2128 20.1461 13.5178C20.1461 13.6918 20.077 13.8587 19.9539 13.9818C19.8308 14.1049 19.6639 14.174 19.4899 14.174H16.6407C15.9119 14.174 15.3084 13.6325 15.0845 12.939C14.7046 11.7152 14.0408 10.5985 13.1472 9.68003C13.0304 9.56038 12.9067 9.45014 12.7829 9.33985Z"/> </svg>',
            'label' => 'Text to Video',
            'link' => \App\Helpers\Classes\MarketplaceHelper::isRegistered('ai-video-pro') ? route('dashboard.user.ai-video-pro.index') : null,
        ],
        [
            'icon' =>
                '<svg width="23" height="23" viewBox="0 0 23 23" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path d="M11.6994 0.700012C5.73511 0.700012 0.899414 5.53571 0.899414 11.5C0.899414 17.4643 5.73511 22.3 11.6994 22.3C17.6637 22.3 22.4994 17.4643 22.4994 11.5C22.4994 5.53571 17.6637 0.700012 11.6994 0.700012ZM15.9573 12.5557C15.3147 13.3306 14.3886 14.119 13.3194 15.0316C12.9549 15.3421 12.5391 15.6958 12.1098 16.0711C11.9964 16.171 11.8506 16.225 11.6994 16.225C11.5482 16.225 11.4024 16.171 11.289 16.0711C10.8597 15.6958 10.4439 15.3421 10.0794 15.0316C9.01021 14.119 8.08412 13.3306 7.44151 12.5557C6.72331 11.689 6.38851 10.8655 6.38851 9.96911C6.38851 9.09431 6.68822 8.28971 7.23092 7.70111C7.78172 7.10441 8.53502 6.77501 9.35581 6.77501C9.96872 6.77501 10.5303 6.96941 11.0244 7.35281C11.2755 7.54451 11.4996 7.78211 11.6994 8.05751C11.8992 7.78211 12.126 7.54451 12.3744 7.35281C12.8685 6.96941 13.4301 6.77501 14.043 6.77501C14.8638 6.77501 15.6171 7.10441 16.1679 7.70111C16.7106 8.28971 17.0103 9.09431 17.0103 9.96911C17.0103 10.8655 16.6755 11.689 15.9573 12.5557Z"/> </svg>',
            'label' => 'Image to Video',
            'link' => \App\Helpers\Classes\MarketplaceHelper::isRegistered('ai-video-pro') ? route('dashboard.user.ai-video-pro.index') : null,
        ],
        [
            'icon' =>
                '<svg width="22" height="22" viewBox="0 0 22 22" fill="currentColor" xmlns="http://www.w3.org/2000/svg"> <path fill-rule="evenodd" clip-rule="evenodd" d="M11 0.25C5.06294 0.25 0.25 5.06294 0.25 11C0.25 16.9371 5.06294 21.75 11 21.75C16.9371 21.75 21.75 16.9371 21.75 11C21.75 5.06294 16.9371 0.25 11 0.25ZM10.9915 5.25C9.1956 5.25 7.73797 6.70407 7.73797 8.5C7.73797 10.2959 9.1956 11.75 10.9915 11.75C12.7874 11.75 14.2451 10.2959 14.2451 8.5C14.2451 6.70407 12.7874 5.25 10.9915 5.25ZM11 13.25C8.85416 13.25 6.90474 14.0916 5.48057 15.459C5.33327 15.6004 5.25 15.7958 5.25 16C5.25 16.2042 5.33327 16.3996 5.48057 16.541C6.90474 17.9084 8.85416 18.75 11 18.75C13.1458 18.75 15.0953 17.9084 16.5194 16.541C16.6667 16.3996 16.75 16.2042 16.75 16C16.75 15.7958 16.6667 15.6004 16.5194 15.459C15.0953 14.0916 13.1458 13.25 11 13.25Z"/> </svg>',
            'label' => 'AI Avatar',
            'link' => \Illuminate\Support\Facades\Route::has('dashboard.user.ai-avatar.index') ? route('dashboard.user.ai-avatar.index') : null,
        ],
    ];
@endphp

@if (collect($advanced_options)->contains(fn($option) => $option['link'] !== null))
    <div
        @class([
            'lqd-adv-img-editor-advanced-options group/advanced-options py-9',
        ])
        :class="{ opened: open, closed: !open }"
        x-data="{ open: true }"
    >
        <button
            class="mb-14 flex w-full items-center gap-7 text-2xs font-medium"
            type="button"
            @click.prevent="open = !open"
        >
            <span class="h-px grow bg-heading-foreground/5"></span>
            <span class="flex items-center gap-2">
                @lang('Advanced Options')
                <x-tabler-chevron-down class="size-4 transition-transform group-[&.closed]/advanced-options:rotate-180" />
            </span>
            <span class="h-px grow bg-heading-foreground/5"></span>
        </button>

        <div
            class="grid grid-cols-1 gap-4 md:grid-cols-4 md:gap-6 lg:grid-cols-5 lg:gap-x-16 lg:gap-y-4"
            x-show="open"
            x-collapse
        >
            @foreach ($advanced_options as $option)
                @continue($option['link'] === null)

                <a
                    class="inline-flex w-full items-center justify-center gap-3 rounded-xl bg-heading-foreground/5 px-5 py-3 text-sm font-medium transition-all hover:scale-105 hover:bg-heading-foreground hover:text-heading-background hover:shadow-xl hover:shadow-black/10"
                    href="{{ $option['link'] }}"
                >
                    <span
                        class="inline-grid size-11 shrink-0 place-items-center rounded-full bg-gradient-to-r from-gradient-from via-gradient-via to-gradient-to text-primary-foreground"
                    >
                        {!! $option['icon'] !!}
                    </span>
                    <span>{{ $option['label'] }}</span>
                </a>
            @endforeach
            <a
                class="inline-flex w-full items-center justify-center gap-3 rounded-xl bg-heading-foreground/5 px-5 py-3 text-sm font-medium transition-all hover:scale-105 hover:bg-heading-foreground hover:text-heading-background hover:shadow-xl hover:shadow-black/10"
                @click.prevent="editingImage = {}; selectedTool = '{{ 'merge_face' }}'; switchToolsCat({toolKey: '{{ 'merge_face' }}'}); switchView('editor');"
            >
                <span
                    class="inline-grid size-11 shrink-0 place-items-center rounded-full bg-gradient-to-r from-gradient-from via-gradient-via to-gradient-to text-primary-foreground"
                >
                    <svg
                        width="21"
                        height="17"
                        viewBox="0 0 21 17"
                        fill="currentColor"
                        xmlns="http://www.w3.org/2000/svg"
                    >
                        <path
                            d="M9.38497 6.86785C8.76819 7.27999 8.04305 7.49996 7.30125 7.49996C6.30694 7.49909 5.3536 7.10377 4.65046 6.40075C3.94732 5.69773 3.55182 4.74446 3.55078 3.75015C3.55065 3.00835 3.7705 2.28317 4.18253 1.66632C4.59456 1.04947 5.18026 0.568666 5.86555 0.284701C6.55085 0.000736028 7.30497 -0.0736292 8.03253 0.0710094C8.76009 0.215648 9.42842 0.572794 9.953 1.09728C10.4776 1.62177 10.8348 2.29004 10.9796 3.01757C11.1244 3.74511 11.0501 4.49924 10.7663 5.18459C10.4824 5.86993 10.0017 6.45571 9.38497 6.86785Z"
                        />
                        <path
                            d="M8.70481 8.6755C10.0374 8.95394 11.2568 9.62332 12.2072 10.5981C12.9549 11.3665 13.5104 12.3008 13.8281 13.3248C14.0415 13.9872 14.1489 14.6791 14.1464 15.375C14.1464 15.549 14.0773 15.7159 13.9542 15.839C13.8311 15.9621 13.6642 16.0312 13.4902 16.0312H1.11328C0.939233 16.0312 0.772313 15.9621 0.649242 15.839C0.526172 15.7159 0.457031 15.549 0.457031 15.375C0.457646 14.0136 0.864077 12.6832 1.62441 11.5539C2.38474 10.4246 3.46445 9.5476 4.72562 9.03488C5.9868 8.52217 7.37218 8.39705 8.70481 8.6755Z"
                        />
                        <path
                            d="M15.2227 7.82809C16.763 7.82809 18.0117 6.57939 18.0117 5.03903C18.0117 3.49868 16.763 2.24997 15.2227 2.24997C13.6823 2.24997 12.4336 3.49868 12.4336 5.03903C12.4336 6.57939 13.6823 7.82809 15.2227 7.82809Z"
                        />
                        <path
                            d="M12.7829 9.33985C12.755 9.31492 12.7593 9.27004 12.7917 9.25134C13.5314 8.82524 14.3698 8.59911 15.2242 8.5959C16.5292 8.59729 17.7803 9.11629 18.703 10.039C19.6257 10.9617 20.1447 12.2128 20.1461 13.5178C20.1461 13.6918 20.077 13.8587 19.9539 13.9818C19.8308 14.1049 19.6639 14.174 19.4899 14.174H16.6407C15.9119 14.174 15.3084 13.6325 15.0845 12.939C14.7046 11.7152 14.0408 10.5985 13.1472 9.68003C13.0304 9.56038 12.9067 9.45014 12.7829 9.33985Z"
                        />
                    </svg>
                </span>
                <span>{{ 'Merge Face' }}</span>
            </a>
        </div>
    </div>
@endif
