<?php
/**
 * EmailStatisticsData
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Emails
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Marketing Emails
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.12.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Emails\Model;

use \ArrayAccess;
use \HubSpot\Client\Marketing\Emails\ObjectSerializer;

/**
 * EmailStatisticsData Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Emails
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class EmailStatisticsData implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'EmailStatisticsData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'device_breakdown' => 'array<string,array<string,int>>',
        'qualifier_stats' => 'array<string,array<string,int>>',
        'counters' => 'array<string,int>',
        'ratios' => 'array<string,float>'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'device_breakdown' => 'int64',
        'qualifier_stats' => 'int64',
        'counters' => 'int64',
        'ratios' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'device_breakdown' => false,
        'qualifier_stats' => false,
        'counters' => false,
        'ratios' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'device_breakdown' => 'deviceBreakdown',
        'qualifier_stats' => 'qualifierStats',
        'counters' => 'counters',
        'ratios' => 'ratios'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'device_breakdown' => 'setDeviceBreakdown',
        'qualifier_stats' => 'setQualifierStats',
        'counters' => 'setCounters',
        'ratios' => 'setRatios'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'device_breakdown' => 'getDeviceBreakdown',
        'qualifier_stats' => 'getQualifierStats',
        'counters' => 'getCounters',
        'ratios' => 'getRatios'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('device_breakdown', $data ?? [], null);
        $this->setIfExists('qualifier_stats', $data ?? [], null);
        $this->setIfExists('counters', $data ?? [], null);
        $this->setIfExists('ratios', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['device_breakdown'] === null) {
            $invalidProperties[] = "'device_breakdown' can't be null";
        }
        if ($this->container['qualifier_stats'] === null) {
            $invalidProperties[] = "'qualifier_stats' can't be null";
        }
        if ($this->container['counters'] === null) {
            $invalidProperties[] = "'counters' can't be null";
        }
        if ($this->container['ratios'] === null) {
            $invalidProperties[] = "'ratios' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets device_breakdown
     *
     * @return array<string,array<string,int>>
     */
    public function getDeviceBreakdown()
    {
        return $this->container['device_breakdown'];
    }

    /**
     * Sets device_breakdown
     *
     * @param array<string,array<string,int>> $device_breakdown Statistics by device.
     *
     * @return self
     */
    public function setDeviceBreakdown($device_breakdown)
    {
        if (is_null($device_breakdown)) {
            throw new \InvalidArgumentException('non-nullable device_breakdown cannot be null');
        }
        $this->container['device_breakdown'] = $device_breakdown;

        return $this;
    }

    /**
     * Gets qualifier_stats
     *
     * @return array<string,array<string,int>>
     */
    public function getQualifierStats()
    {
        return $this->container['qualifier_stats'];
    }

    /**
     * Sets qualifier_stats
     *
     * @param array<string,array<string,int>> $qualifier_stats Number of emails that were dropped and bounced.
     *
     * @return self
     */
    public function setQualifierStats($qualifier_stats)
    {
        if (is_null($qualifier_stats)) {
            throw new \InvalidArgumentException('non-nullable qualifier_stats cannot be null');
        }
        $this->container['qualifier_stats'] = $qualifier_stats;

        return $this;
    }

    /**
     * Gets counters
     *
     * @return array<string,int>
     */
    public function getCounters()
    {
        return $this->container['counters'];
    }

    /**
     * Sets counters
     *
     * @param array<string,int> $counters Counters like number of `sent`, `open` or `delivered`.
     *
     * @return self
     */
    public function setCounters($counters)
    {
        if (is_null($counters)) {
            throw new \InvalidArgumentException('non-nullable counters cannot be null');
        }
        $this->container['counters'] = $counters;

        return $this;
    }

    /**
     * Gets ratios
     *
     * @return array<string,float>
     */
    public function getRatios()
    {
        return $this->container['ratios'];
    }

    /**
     * Sets ratios
     *
     * @param array<string,float> $ratios Ratios like `openratio` or `clickratio`
     *
     * @return self
     */
    public function setRatios($ratios)
    {
        if (is_null($ratios)) {
            throw new \InvalidArgumentException('non-nullable ratios cannot be null');
        }
        $this->container['ratios'] = $ratios;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


