<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\WorkspaceEvents;

class HTTPAuthSecurityScheme extends \Google\Model
{
  /**
   * @var string
   */
  public $bearerFormat;
  /**
   * @var string
   */
  public $description;
  /**
   * @var string
   */
  public $scheme;

  /**
   * @param string
   */
  public function setBearerFormat($bearerFormat)
  {
    $this->bearerFormat = $bearerFormat;
  }
  /**
   * @return string
   */
  public function getBearerFormat()
  {
    return $this->bearerFormat;
  }
  /**
   * @param string
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * @param string
   */
  public function setScheme($scheme)
  {
    $this->scheme = $scheme;
  }
  /**
   * @return string
   */
  public function getScheme()
  {
    return $this->scheme;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(HTTPAuthSecurityScheme::class, 'Google_Service_WorkspaceEvents_HTTPAuthSecurityScheme');
