<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Container;

class CertificateConfigPair extends \Google\Model
{
  protected $certType = CertificateConfig::class;
  protected $certDataType = '';
  protected $keyType = CertificateConfig::class;
  protected $keyDataType = '';

  /**
   * @param CertificateConfig
   */
  public function setCert(CertificateConfig $cert)
  {
    $this->cert = $cert;
  }
  /**
   * @return CertificateConfig
   */
  public function getCert()
  {
    return $this->cert;
  }
  /**
   * @param CertificateConfig
   */
  public function setKey(CertificateConfig $key)
  {
    $this->key = $key;
  }
  /**
   * @return CertificateConfig
   */
  public function getKey()
  {
    return $this->key;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CertificateConfigPair::class, 'Google_Service_Container_CertificateConfigPair');
