<?php

namespace RachidLaasri\LaravelInstaller\Repositories;

use App\Models\SettingTwo;
use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Storage;

class ApplicationStatusRepository implements ApplicationStatusRepositoryInterface
{
    public string $baseLicenseUrl = 'https://portal.liquid-themes.com/api/license';

    public function financePage(string $view = 'panel.admin.finance.gateways.particles.finance'): string
    {
        return $view;
    }

    public function financeLicense(): bool
    {
        return true;
    }

    public function licenseType(): ?string
    {
        return 'Extended License';
    }

    public function check(string $licenseKey, bool $installed = false): bool
    {
        $data = [
            'liquid_license_type' => 'Extended License',
            'liquid_license_domain_key' => '322c8678-96fd-4319-b5af-04c9179561fe',
            'installed' => $installed,
        ];

        return $this->save($data);
    }

    public function portal()
    {
        $data = Storage::disk('local')->get('portal');

        if ($data) {
            $portal = unserialize(trim($data));
            $portal['liquid_license_type'] = 'Extended License';
            $portal['liquid_license_domain_key'] = '322c8678-96fd-4319-b5af-04c9179561fe';
            return $portal;
        }

        return [
            'liquid_license_type' => 'Extended License',
            'liquid_license_domain_key' => '322c8678-96fd-4319-b5af-04c9179561fe',
            'installed' => true
        ];
    }

    public function getVariable(string $key)
    {
        $portal = $this->portal();

        return data_get($portal, $key);
    }

    public function save($data): bool
    {
        $data['liquid_license_type'] = 'Extended License';
        $data['liquid_license_domain_key'] = '322c8678-96fd-4319-b5af-04c9179561fe';
        return Storage::disk('local')->put('portal', serialize($data));
    }

    public function setLicense(): void
    {
        $data = $this->portal();

        if (is_null($data)) {
            $data = [
                'liquid_license_type' => 'Extended License',
                'liquid_license_domain_key' => '322c8678-96fd-4319-b5af-04c9179561fe',
                'installed' => true
            ];
        }

        $data['installed'] = true;
        $data['liquid_license_type'] = 'Extended License';
        $data['liquid_license_domain_key'] = '322c8678-96fd-4319-b5af-04c9179561fe';

        $this->save($data);

        if (
            Schema::hasTable('settings_two')
            && Schema::hasColumn('settings_two', 'liquid_license_type')
            && Schema::hasColumn('settings_two', 'liquid_license_domain_key')
        ) {
            SettingTwo::query()->first()->update([
                'liquid_license_type' => 'Extended License',
                'liquid_license_domain_key' => '322c8678-96fd-4319-b5af-04c9179561fe',
            ]);
        }
    }

    public function generate(Request $request): bool
    {
        return true;
    }

    public function next($request, Closure $next)
    {
        return $next($request);
    }

    public function webhook($request)
    {
        return response()->noContent();
    }

    public function appKey(): string
    {
        return md5(config('app.key'));
    }
}
