<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dfareporting;

class DynamicProfileFeedSettings extends \Google\Model
{
  /**
   * @var string
   */
  public $dynamicFeedId;
  protected $dynamicRulesType = DynamicRules::class;
  protected $dynamicRulesDataType = '';
  /**
   * @var int
   */
  public $quantity;

  /**
   * @param string
   */
  public function setDynamicFeedId($dynamicFeedId)
  {
    $this->dynamicFeedId = $dynamicFeedId;
  }
  /**
   * @return string
   */
  public function getDynamicFeedId()
  {
    return $this->dynamicFeedId;
  }
  /**
   * @param DynamicRules
   */
  public function setDynamicRules(DynamicRules $dynamicRules)
  {
    $this->dynamicRules = $dynamicRules;
  }
  /**
   * @return DynamicRules
   */
  public function getDynamicRules()
  {
    return $this->dynamicRules;
  }
  /**
   * @param int
   */
  public function setQuantity($quantity)
  {
    $this->quantity = $quantity;
  }
  /**
   * @return int
   */
  public function getQuantity()
  {
    return $this->quantity;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DynamicProfileFeedSettings::class, 'Google_Service_Dfareporting_DynamicProfileFeedSettings');
